/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.utils;

import org.apache.camel.component.soroushbot.utils.BackOffStrategy;

public class ExponentialBackOffStrategy
implements BackOffStrategy {
    Long baseRetryTimeOut;
    Long coefficient;
    Long maxRetryWaitingTime;

    public ExponentialBackOffStrategy(Long baseRetryTimeOut, Long coefficient, Long maxRetryWaitingTime) {
        this.baseRetryTimeOut = baseRetryTimeOut;
        this.coefficient = coefficient;
        this.maxRetryWaitingTime = maxRetryWaitingTime;
    }

    @Override
    public void waitBeforeRetry(int retryCount) throws InterruptedException {
        if ((retryCount -= 2) >= 0) {
            Thread.sleep((long)((double)this.baseRetryTimeOut.longValue() * Math.pow(this.coefficient.longValue(), retryCount)));
        }
    }
}

