/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.component.soroushbot.models.CustomKey;
import org.apache.camel.component.soroushbot.models.FileType;
import org.apache.camel.component.soroushbot.models.MinorType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SoroushMessage
implements Cloneable {
    private String to;
    private String from;
    private String body;
    private MinorType type;
    private String time;
    private String fileName;
    private FileType fileType;
    private Double fileSize;
    private String fileUrl;
    private String thumbnailUrl;
    private Double imageWidth;
    private Double imageHeight;
    private Double fileDuration;
    private Double thumbnailWidth;
    private Double thumbnailHeight;
    private String nickName;
    private String avatarUrl;
    private Double phoneNo;
    private Double latitude;
    private Double longitude;
    private List<List<CustomKey>> keyboard;
    @JsonIgnore
    private InputStream file;
    @JsonIgnore
    private InputStream thumbnail;

    public SoroushMessage() {
    }

    public SoroushMessage(String to, String from, String body, MinorType type, String time, String fileName, FileType fileType, Double fileSize, String fileUrl, String thumbnailUrl, Double imageWidth, Double imageHeight, Double fileDuration, Double thumbnailWidth, Double thumbnailHeight, String nickName, String avatarUrl, Double phoneNo, Double latitude, Double longitude, List<List<CustomKey>> keyboard) {
        this.to = to;
        this.from = from;
        this.body = body;
        this.type = type;
        this.time = time;
        this.fileName = fileName;
        this.fileType = fileType;
        this.fileSize = fileSize;
        this.fileUrl = fileUrl;
        this.thumbnailUrl = thumbnailUrl;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.fileDuration = fileDuration;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.nickName = nickName;
        this.avatarUrl = avatarUrl;
        this.phoneNo = phoneNo;
        this.latitude = latitude;
        this.longitude = longitude;
        this.keyboard = keyboard;
    }

    @JsonIgnore
    public void setFile(File file) throws FileNotFoundException {
        this.file = new BufferedInputStream(new FileInputStream(file));
    }

    @JsonIgnore
    public void setThumbnail(File thumbnail) throws FileNotFoundException {
        this.thumbnail = new BufferedInputStream(new FileInputStream(thumbnail));
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MinorType getType() {
        return this.type;
    }

    public void setType(MinorType type) {
        this.type = type;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public Double getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Double fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public Double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(Double imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Double getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(Double imageHeight) {
        this.imageHeight = imageHeight;
    }

    public Double getFileDuration() {
        return this.fileDuration;
    }

    public void setFileDuration(Double fileDuration) {
        this.fileDuration = fileDuration;
    }

    public Double getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailWidth(Double thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    public Double getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailHeight(Double thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Double getPhoneNo() {
        return this.phoneNo;
    }

    public void setPhoneNo(Double phoneNo) {
        this.phoneNo = phoneNo;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public List<List<CustomKey>> getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(List<List<CustomKey>> keyboard) {
        this.keyboard = keyboard;
    }

    public InputStream getFile() {
        return this.file;
    }

    public void setFile(InputStream file) {
        this.file = file;
    }

    public InputStream getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(InputStream thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String toString() {
        return "SoroushMessage{to='" + this.to + '\'' + ", from='" + this.from + '\'' + ", body='" + this.body + '\'' + ", type=" + (Object)((Object)this.type) + ", time='" + this.time + '\'' + ", fileName='" + this.fileName + '\'' + ", fileType=" + (Object)((Object)this.fileType) + ", fileSize=" + this.fileSize + ", fileUrl='" + this.fileUrl + '\'' + ", thumbnailUrl='" + this.thumbnailUrl + '\'' + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", fileDuration=" + this.fileDuration + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + ", nickName='" + this.nickName + '\'' + ", avatarUrl='" + this.avatarUrl + '\'' + ", phoneNo=" + this.phoneNo + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", keyboard=" + this.keyboard + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoroushMessage)) {
            return false;
        }
        SoroushMessage that = (SoroushMessage)o;
        return Objects.equals(this.getTo(), that.getTo()) && Objects.equals(this.getFrom(), that.getFrom()) && Objects.equals(this.getBody(), that.getBody()) && this.getType() == that.getType() && Objects.equals(this.getTime(), that.getTime()) && Objects.equals(this.getFileName(), that.getFileName()) && this.getFileType() == that.getFileType() && Objects.equals(this.getFileSize(), that.getFileSize()) && Objects.equals(this.getFileUrl(), that.getFileUrl()) && Objects.equals(this.getThumbnailUrl(), that.getThumbnailUrl()) && Objects.equals(this.getImageWidth(), that.getImageWidth()) && Objects.equals(this.getImageHeight(), that.getImageHeight()) && Objects.equals(this.getFileDuration(), that.getFileDuration()) && Objects.equals(this.getThumbnailWidth(), that.getThumbnailWidth()) && Objects.equals(this.getThumbnailHeight(), that.getThumbnailHeight()) && Objects.equals(this.getNickName(), that.getNickName()) && Objects.equals(this.getAvatarUrl(), that.getAvatarUrl()) && Objects.equals(this.getPhoneNo(), that.getPhoneNo()) && Objects.equals(this.getLatitude(), that.getLatitude()) && Objects.equals(this.getLongitude(), that.getLongitude()) && Objects.equals(this.getKeyboard(), that.getKeyboard());
    }

    public SoroushMessage clone() throws CloneNotSupportedException {
        return new SoroushMessage(this.to, this.from, this.body, this.type, this.time, this.fileName, this.fileType, this.fileSize, this.fileUrl, this.thumbnailUrl, this.imageWidth, this.imageHeight, this.fileDuration, this.thumbnailWidth, this.thumbnailHeight, this.nickName, this.avatarUrl, this.phoneNo, this.latitude, this.longitude, this.keyboard == null ? null : this.keyboard.stream().map(it -> it == null ? null : new ArrayList(it)).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTo(), this.getFrom(), this.getBody(), this.getType(), this.getTime(), this.getFileName(), this.getFileType(), this.getFileSize(), this.getFileUrl(), this.getThumbnailUrl(), this.getImageWidth(), this.getImageHeight(), this.getFileDuration(), this.getThumbnailWidth(), this.getThumbnailHeight(), this.getNickName(), this.getAvatarUrl(), this.getPhoneNo(), this.getLatitude(), this.getLongitude(), this.getKeyboard()});
    }
}

