/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import java.util.UUID;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.cm.CMComponent;
import org.apache.camel.component.cm.CMConfiguration;
import org.apache.camel.component.cm.CMProducer;
import org.apache.camel.component.cm.CMSenderOneMessageImpl;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="2.18.0", scheme="cm-sms", title="CM SMS Gateway", syntax="cm-sms:host", label="mobile", producerOnly=true)
public class CMEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriParam
    private CMConfiguration configuration;

    public CMEndpoint(String uri, CMComponent component) {
        super(uri, (Component)component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public CMProducer createProducer() throws Exception {
        CMConfiguration config = this.getConfiguration();
        String token = config.getProductToken();
        StringHelper.notEmpty((String)token, (String)"productToken");
        UUID uuid = UUID.fromString(token);
        return new CMProducer(this, new CMSenderOneMessageImpl(this.getCMUrl(), uuid));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public CMConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CMConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getCMUrl() {
        return "https://" + this.host;
    }

    public CMComponent getComponent() {
        return (CMComponent)super.getComponent();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

