/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingHelper;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;

@UriParams
public class EhcacheConfiguration
implements Cloneable {
    @UriParam(defaultValue="true")
    private boolean createCacheIfNotExist = true;
    @UriParam(label="producer")
    private String action;
    @UriParam(label="producer")
    private Object key;
    @UriParam
    private CacheManager cacheManager;
    @UriParam
    private Configuration cacheManagerConfiguration;
    @UriParam
    private String configurationUri;
    @UriParam(label="advanced")
    private CacheConfiguration configuration;
    @UriParam(label="advanced")
    private Map<String, CacheConfiguration> configurations;
    @UriParam(label="advanced")
    private String keyType;
    @UriParam(label="advanced")
    private String valueType;
    @UriParam(label="consumer", defaultValue="ORDERED")
    private EventOrdering eventOrdering = EventOrdering.ORDERED;
    @UriParam(label="consumer", defaultValue="ASYNCHRONOUS")
    private EventFiring eventFiring = EventFiring.ASYNCHRONOUS;
    @UriParam(label="consumer", enums="EVICTED,EXPIRED,REMOVED,CREATED,UPDATED", defaultValue="EVICTED,EXPIRED,REMOVED,CREATED,UPDATED")
    private Set<EventType> eventTypes = EnumSet.of(EventType.values()[0], EventType.values());

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public boolean hasConfigurationUri() {
        return ObjectHelper.isNotEmpty((Object)this.configurationUri);
    }

    @Deprecated
    public String getConfigUri() {
        return this.getConfigurationUri();
    }

    @Deprecated
    @Metadata(deprecationNote="use configurationUri instead")
    public void setConfigUri(String configUri) {
        this.setConfigurationUri(configUri);
    }

    public boolean isCreateCacheIfNotExist() {
        return this.createCacheIfNotExist;
    }

    public void setCreateCacheIfNotExist(boolean createCacheIfNotExist) {
        this.createCacheIfNotExist = createCacheIfNotExist;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean hasCacheManager() {
        return this.cacheManager != null;
    }

    public Configuration getCacheManagerConfiguration() {
        return this.cacheManagerConfiguration;
    }

    public void setCacheManagerConfiguration(Configuration cacheManagerConfiguration) {
        this.cacheManagerConfiguration = cacheManagerConfiguration;
    }

    public boolean hasCacheManagerConfiguration() {
        return this.cacheManagerConfiguration != null;
    }

    public EventOrdering getEventOrdering() {
        return this.eventOrdering;
    }

    public void setEventOrdering(String eventOrdering) {
        this.setEventOrdering(EventOrdering.valueOf((String)eventOrdering));
    }

    public void setEventOrdering(EventOrdering eventOrdering) {
        this.eventOrdering = eventOrdering;
    }

    public EventFiring getEventFiring() {
        return this.eventFiring;
    }

    public void setEventFiring(String eventFiring) {
        this.setEventFiring(EventFiring.valueOf((String)eventFiring));
    }

    public void setEventFiring(EventFiring eventFiring) {
        this.eventFiring = eventFiring;
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(String eventTypesString) {
        String[] events;
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        for (String event : events = eventTypesString.split(",")) {
            eventTypes.add(EventType.valueOf((String)event));
        }
        this.setEventTypes(eventTypes);
    }

    public void setEventTypes(Set<EventType> eventTypes) {
        this.eventTypes = new HashSet<EventType>(eventTypes);
    }

    public void setConfiguration(CacheConfiguration<?, ?> configuration) {
        this.configuration = configuration;
    }

    public CacheConfiguration<?, ?> getConfiguration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return ObjectHelper.isNotEmpty((Object)this.configuration);
    }

    public boolean hasConfiguration(String name) {
        return (Boolean)ThrowingHelper.applyIfNotEmpty(this.configurations, c -> c.containsKey(name), () -> false);
    }

    public Map<String, CacheConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, CacheConfiguration> configurations) {
        this.configurations = (Map)Map.class.cast(configurations);
    }

    public void addConfigurations(Map<String, CacheConfiguration> configurations) {
        if (this.configurations == null) {
            this.configurations = new HashMap<String, CacheConfiguration>();
        }
        this.configurations.putAll(configurations);
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public EhcacheConfiguration copy() {
        try {
            return (EhcacheConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

