/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.services.sns.util.Topics;
import com.amazonaws.services.sqs.AmazonSQS;
import java.util.HashMap;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsHeaderFilterStrategy;
import org.apache.camel.component.aws.sns.SnsProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.8.0", scheme="aws-sns", title="AWS Simple Notification System", syntax="aws-sns:topicNameOrArn", producerOnly=true, label="cloud,mobile,messaging")
public class SnsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private AmazonSNS snsClient;
    @UriPath(description="Topic name or ARN")
    @Metadata(required=true)
    private String topicNameOrArn;
    @UriParam
    private SnsConfiguration configuration;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public SnsEndpoint(String uri, Component component, SnsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SnsProducer((Endpoint)this);
    }

    public void doInit() throws Exception {
        super.doInit();
        AmazonSNS amazonSNS = this.snsClient = this.configuration.getAmazonSNSClient() != null ? this.configuration.getAmazonSNSClient() : this.createSNSClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SnsHeaderFilterStrategy();
        }
        if (this.configuration.getTopicArn() == null) {
            try {
                String nextToken = null;
                String arnSuffix = ":" + this.configuration.getTopicName();
                block2: do {
                    ListTopicsResult response = this.snsClient.listTopics(nextToken);
                    nextToken = response.getNextToken();
                    for (Topic topic : response.getTopics()) {
                        if (!topic.getTopicArn().endsWith(arnSuffix)) continue;
                        this.configuration.setTopicArn(topic.getTopicArn());
                        continue block2;
                    }
                } while (nextToken != null);
            }
            catch (AmazonServiceException ase) {
                this.log.trace("The list topics operation return the following error code {}", (Object)ase.getErrorCode());
                throw ase;
            }
        }
        if (this.configuration.getTopicArn() == null && this.configuration.isAutoCreateTopic()) {
            CreateTopicRequest request = new CreateTopicRequest(this.configuration.getTopicName());
            if (this.configuration.isServerSideEncryptionEnabled() && ObjectHelper.isNotEmpty((Object)this.configuration.getKmsMasterKeyId())) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("KmsMasterKeyId", this.configuration.getKmsMasterKeyId());
                request.setAttributes(attributes);
            }
            this.log.trace("Creating topic [{}] with request [{}]...", (Object)this.configuration.getTopicName(), (Object)request);
            CreateTopicResult result = this.snsClient.createTopic(request);
            this.configuration.setTopicArn(result.getTopicArn());
            this.log.trace("Topic created with Amazon resource name: {}", (Object)this.configuration.getTopicArn());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getPolicy())) {
            this.log.trace("Updating topic [{}] with policy [{}]", (Object)this.configuration.getTopicArn(), (Object)this.configuration.getPolicy());
            this.snsClient.setTopicAttributes(new SetTopicAttributesRequest(this.configuration.getTopicArn(), "Policy", this.configuration.getPolicy()));
            this.log.trace("Topic policy updated");
        }
        if (this.configuration.isSubscribeSNStoSQS()) {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonSQSClient()) && ObjectHelper.isNotEmpty((Object)this.configuration.getQueueUrl())) {
                String subscriptionARN = Topics.subscribeQueue((AmazonSNS)this.snsClient, (AmazonSQS)this.configuration.getAmazonSQSClient(), (String)this.configuration.getTopicArn(), (String)this.configuration.getQueueUrl());
                this.log.trace("Subscription of SQS Queue to SNS Topic done with Amazon resource name: {}", (Object)subscriptionARN);
            } else {
                throw new IllegalArgumentException("Using the SubscribeSNStoSQS option require both AmazonSQSClient and Queue URL options");
            }
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSNSClient()) && this.snsClient != null) {
            this.snsClient.shutdown();
        }
        super.doStop();
    }

    public SnsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SnsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setSNSClient(AmazonSNS snsClient) {
        this.snsClient = snsClient;
    }

    public AmazonSNS getSNSClient() {
        return this.snsClient;
    }

    AmazonSNS createSNSClient() {
        AmazonSNS client = null;
        AmazonSNSClientBuilder clientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonSNSClientBuilder.standard() : (AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonSNSClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonSNS)clientBuilder.build();
        return client;
    }
}

