/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hipchat.HipchatComponent;
import org.apache.camel.component.hipchat.HipchatConfiguration;
import org.apache.camel.component.hipchat.HipchatConsumer;
import org.apache.camel.component.hipchat.HipchatProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.15.0", scheme="hipchat", title="Hipchat", syntax="hipchat:protocol:host:port", label="api,cloud")
public class HipchatEndpoint
extends ScheduledPollEndpoint {
    @UriParam(defaultValue="5000", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 5000L;
    @UriParam
    private HipchatConfiguration configuration;

    public HipchatEndpoint(String uri, HipchatComponent component) {
        super(uri, (Component)component);
        this.setDelay(5000L);
        this.configuration = new HipchatConfiguration();
    }

    public Producer createProducer() throws Exception {
        return new HipchatProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HipchatConsumer consumer = new HipchatConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public HipchatConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

