/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import com.box.sdk.IAccessTokenCache;
import com.box.sdk.InMemoryLRUAccessTokenCache;
import com.box.sdk.JWTEncryptionPreferences;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.http.HttpHost;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoxConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BoxConnectionHelper.class);
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("&?([^=]+)=([^&]+)");

    private BoxConnectionHelper() {
    }

    public static BoxAPIConnection createConnection(BoxConfiguration configuration) {
        if (configuration.getAuthenticationType() == null) {
            throw new RuntimeCamelException("Box API connection failed: Authentication type not specified in configuration");
        }
        switch (configuration.getAuthenticationType()) {
            case "APP_ENTERPRISE_AUTHENTICATION": {
                return BoxConnectionHelper.createAppEnterpriseAuthenticatedConnection(configuration);
            }
            case "APP_USER_AUTHENTICATION": {
                return BoxConnectionHelper.createAppUserAuthenticatedConnection(configuration);
            }
            case "STANDARD_AUTHENTICATION": {
                return BoxConnectionHelper.createStandardAuthenticatedConnection(configuration);
            }
        }
        throw new RuntimeCamelException(String.format("Box API connection failed: Invalid authentication type '%s'", configuration.getAuthenticationType()));
    }

    public static BoxAPIConnection createStandardAuthenticatedConnection(BoxConfiguration configuration) {
        try {
            Proxy proxy;
            Map<String, Object> httpParams = configuration.getHttpParams();
            if (httpParams != null && httpParams.get("http.route.default-proxy") != null) {
                HttpHost proxyHost = (HttpHost)httpParams.get("http.route.default-proxy");
                Boolean socksProxy = (Boolean)httpParams.get("http.route.socks-proxy");
                InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost.getHostName(), proxyHost.getPort());
                proxy = socksProxy != null && socksProxy.booleanValue() ? new Proxy(Proxy.Type.SOCKS, proxyAddr) : new Proxy(Proxy.Type.HTTP, proxyAddr);
            } else {
                proxy = null;
            }
            String csrfToken = String.valueOf(new SecureRandom().nextLong());
            String authorizeUrl = BoxConnectionHelper.authorizationUrl(configuration.getClientId(), csrfToken);
            Connection.Response loginPageResponse = BoxConnectionHelper.addProxy(Jsoup.connect((String)authorizeUrl), proxy).method(Connection.Method.GET).execute();
            Document loginPage = loginPageResponse.parse();
            BoxConnectionHelper.validatePage(loginPage);
            FormElement loginForm = (FormElement)loginPage.select("form[name=login_form]").first();
            Element loginField = loginForm.select("input[name=login]").first();
            loginField.val(configuration.getUserName());
            Element passwordField = loginForm.select("input[name=password]").first();
            passwordField.val(configuration.getUserPassword());
            HashMap cookies = new HashMap();
            cookies.putAll(loginPageResponse.cookies());
            Connection.Response response = BoxConnectionHelper.addProxy(loginForm.submit(), proxy).cookies(cookies).execute();
            cookies.putAll(response.cookies());
            Document consentPage = response.parse();
            BoxConnectionHelper.validatePage(consentPage);
            FormElement consentForm = (FormElement)consentPage.select("form[name=consent_form]").first();
            consentForm.elements().removeIf(e -> e.attr("name").equals("consent_reject"));
            String requestTokenScript = consentPage.select("script").first().html();
            Matcher m = Pattern.compile("var\\s+request_token\\s+=\\s+'([^'].+)'.*").matcher(requestTokenScript);
            if (!m.find()) {
                throw new IllegalArgumentException("Error authorizing application: Can not parse request token.");
            }
            String requestToken = m.group(1);
            response = BoxConnectionHelper.addProxy(consentForm.submit(), proxy).data("request_token", requestToken).followRedirects(false).cookies(cookies).execute();
            String location = response.header("Location");
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(new URL(location).getQuery());
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
            String state = (String)params.get("state");
            if (!csrfToken.equals(state)) {
                throw new SecurityException("Invalid CSRF code!");
            }
            String authorizationCode = (String)params.get("code");
            return new BoxAPIConnection(configuration.getClientId(), configuration.getClientSecret(), authorizationCode);
        }
        catch (BoxAPIException e2) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d%n%n%s", e2.getResponseCode(), e2.getResponse()), (Throwable)e2);
        }
        catch (Exception e3) {
            throw new RuntimeCamelException(String.format("Box API connection failed: %s", e3.getMessage()), (Throwable)e3);
        }
    }

    private static void validatePage(Document page) {
        Elements captchaDivs = page.select("div[class*=g-recaptcha]");
        if (!captchaDivs.isEmpty()) {
            throw new IllegalArgumentException("Authentication requires CAPTCHA test. First you need to authenticate the account manually via web to unlock CAPTCHA.");
        }
        Elements twoStepDivs = page.select("div[data-module=two-factor-enroll-form]");
        if (!twoStepDivs.isEmpty()) {
            throw new IllegalArgumentException("2-step verification is enabled on the Box account. Turn it off for camel-box to proceed the standard authentication.");
        }
        Elements errorDivs = page.select("div[class*=error_message]");
        String errorMessage = null;
        if (!errorDivs.isEmpty()) {
            errorMessage = errorDivs.first().text().replaceAll("\\s+", " ").replaceAll(" Show Error Details", ":").trim();
        } else {
            errorDivs = page.select("div[class*=message]");
            if (!errorDivs.isEmpty()) {
                errorMessage = errorDivs.first().text();
            }
        }
        if (!errorDivs.isEmpty()) {
            throw new IllegalArgumentException("Error authorizing application: " + errorMessage);
        }
    }

    private static Connection addProxy(Connection connection, Proxy proxy) {
        if (proxy != null) {
            return connection.proxy(proxy);
        }
        return connection;
    }

    public static BoxAPIConnection createAppUserAuthenticatedConnection(BoxConfiguration configuration) {
        JWTEncryptionPreferences encryptionPref = new JWTEncryptionPreferences();
        encryptionPref.setPublicKeyID(configuration.getPublicKeyId());
        try {
            encryptionPref.setPrivateKey(new String(Files.readAllBytes(Paths.get(configuration.getPrivateKeyFile(), new String[0]))));
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Box API connection failed: could not read privateKeyFile", (Throwable)e);
        }
        encryptionPref.setPrivateKeyPassword(configuration.getPrivateKeyPassword());
        encryptionPref.setEncryptionAlgorithm(configuration.getEncryptionAlgorithm());
        IAccessTokenCache accessTokenCache = configuration.getAccessTokenCache();
        if (accessTokenCache == null) {
            accessTokenCache = new InMemoryLRUAccessTokenCache(configuration.getMaxCacheEntries());
        }
        try {
            return BoxDeveloperEditionAPIConnection.getAppUserConnection((String)configuration.getUserId(), (String)configuration.getClientId(), (String)configuration.getClientSecret(), (JWTEncryptionPreferences)encryptionPref, (IAccessTokenCache)accessTokenCache);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public static BoxAPIConnection createAppEnterpriseAuthenticatedConnection(BoxConfiguration configuration) {
        JWTEncryptionPreferences encryptionPref = new JWTEncryptionPreferences();
        encryptionPref.setPublicKeyID(configuration.getPublicKeyId());
        try {
            encryptionPref.setPrivateKey(new String(Files.readAllBytes(Paths.get(configuration.getPrivateKeyFile(), new String[0]))));
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Box API connection failed: could not read privateKeyFile", (Throwable)e);
        }
        encryptionPref.setPrivateKeyPassword(configuration.getPrivateKeyPassword());
        encryptionPref.setEncryptionAlgorithm(configuration.getEncryptionAlgorithm());
        IAccessTokenCache accessTokenCache = configuration.getAccessTokenCache();
        if (accessTokenCache == null) {
            accessTokenCache = new InMemoryLRUAccessTokenCache(configuration.getMaxCacheEntries());
        }
        try {
            return BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((String)configuration.getEnterpriseId(), (String)configuration.getClientId(), (String)configuration.getClientSecret(), (JWTEncryptionPreferences)encryptionPref, (IAccessTokenCache)accessTokenCache);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public static String authorizationUrl(String clientId, String stateToken) {
        return "https://account.box.com/api/oauth2/authorize?response_type=code&redirect_url=https%3A%2F%2Flocalhost%2F&client_id=" + clientId + "&state=" + stateToken;
    }
}

