/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.EventType;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.EndpointHelper;

@UriParams
public class JCacheConfiguration {
    @UriParam(label="common")
    private String cachingProvider;
    @UriParam
    private Configuration cacheConfiguration;
    @UriParam
    private Properties cacheConfigurationProperties;
    @UriParam
    private String configurationUri;
    @UriParam(label="advanced")
    private Factory<CacheLoader> cacheLoaderFactory;
    @UriParam(label="advanced")
    private Factory<CacheWriter> cacheWriterFactory;
    @UriParam(label="advanced")
    private Factory<ExpiryPolicy> expiryPolicyFactory;
    @UriParam
    private boolean readThrough;
    @UriParam
    private boolean writeThrough;
    @UriParam(defaultValue="true")
    private boolean storeByValue = true;
    @UriParam
    private boolean statisticsEnabled;
    @UriParam
    private boolean managementEnabled;
    @UriParam(label="consumer", enums="CREATED,UPDATED,REMOVED,EXPIRED")
    private List<EventType> filteredEvents;
    @UriParam(label="consumer,advanced")
    private List<CacheEntryEventFilter> eventFilters;
    @UriParam(label="consumer")
    private boolean oldValueRequired;
    @UriParam(label="consumer")
    private boolean synchronous;
    @UriParam(label="producer")
    private String action;
    @UriParam(label="advanced", defaultValue="true")
    private boolean createCacheIfNotExists = true;
    @UriParam(label="advanced")
    private boolean lookupProviders;
    private CamelContext camelContext;
    private String cacheName;

    public JCacheConfiguration() {
        this(null, null);
    }

    public JCacheConfiguration(String cacheName) {
        this(null, cacheName);
    }

    public JCacheConfiguration(CamelContext camelContext, String cacheName) {
        this.camelContext = camelContext;
        this.cacheName = cacheName;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public ClassLoader getApplicationContextClassLoader() {
        return this.camelContext != null ? this.camelContext.getApplicationContextClassLoader() : null;
    }

    public String getCachingProvider() {
        return this.cachingProvider;
    }

    public void setCachingProvider(String cachingProvider) {
        this.cachingProvider = cachingProvider;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public Properties getCacheConfigurationProperties() {
        return this.cacheConfigurationProperties;
    }

    public void setCacheConfigurationProperties(Properties cacheConfigurationProperties) {
        this.cacheConfigurationProperties = cacheConfigurationProperties;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public Factory<CacheLoader> getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public void setCacheLoaderFactory(Factory<CacheLoader> cacheLoaderFactory) {
        this.cacheLoaderFactory = cacheLoaderFactory;
    }

    public Factory<CacheWriter> getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public void setCacheWriterFactory(Factory<CacheWriter> cacheWriterFactory) {
        this.cacheWriterFactory = cacheWriterFactory;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public void setExpiryPolicyFactory(Factory<ExpiryPolicy> expiryPolicyFactory) {
        this.expiryPolicyFactory = expiryPolicyFactory;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public void setReadThrough(boolean readThrough) {
        this.readThrough = readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public void setManagementEnabled(boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
    }

    public List<EventType> getFilteredEvents() {
        return this.filteredEvents;
    }

    public void setFilteredEvents(List<EventType> filteredEvents) {
        this.filteredEvents = filteredEvents;
    }

    public void setFilteredEvents(String filteredEvents) {
        this.filteredEvents = new ArrayList<EventType>();
        for (String event : filteredEvents.split(",")) {
            this.filteredEvents.add(EventType.valueOf((String)event));
        }
    }

    public List<CacheEntryEventFilter> getEventFilters() {
        return this.eventFilters;
    }

    public void setEventFilters(List<CacheEntryEventFilter> eventFilters) {
        this.eventFilters = new LinkedList<CacheEntryEventFilter>(eventFilters);
    }

    public void setEventFilters(String eventFilter) {
        this.eventFilters = EndpointHelper.resolveReferenceListParameter((CamelContext)this.camelContext, (String)eventFilter, CacheEntryEventFilter.class);
    }

    public boolean isOldValueRequired() {
        return this.oldValueRequired;
    }

    public void setOldValueRequired(boolean oldValueRequired) {
        this.oldValueRequired = oldValueRequired;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isCreateCacheIfNotExists() {
        return this.createCacheIfNotExists;
    }

    public void setCreateCacheIfNotExists(boolean createCacheIfNotExists) {
        this.createCacheIfNotExists = createCacheIfNotExists;
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }
}

