/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.transformer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.model.transformer.CustomTransformerDefinition;
import org.apache.camel.model.transformer.DataFormatTransformerDefinition;
import org.apache.camel.model.transformer.EndpointTransformerDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.reifier.transformer.CustomTransformeReifier;
import org.apache.camel.reifier.transformer.DataFormatTransformeReifier;
import org.apache.camel.reifier.transformer.EndpointTransformeReifier;
import org.apache.camel.spi.Transformer;

public abstract class TransformerReifier<T> {
    private static final Map<Class<?>, Function<TransformerDefinition, TransformerReifier<? extends TransformerDefinition>>> TRANSFORMERS;
    protected final T definition;

    public TransformerReifier(T definition) {
        this.definition = definition;
    }

    public static TransformerReifier<? extends TransformerDefinition> reifier(TransformerDefinition definition) {
        Function<TransformerDefinition, TransformerReifier<? extends TransformerDefinition>> reifier = TRANSFORMERS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public Transformer createTransformer(CamelContext context) throws Exception {
        return this.doCreateTransformer(context);
    }

    protected abstract Transformer doCreateTransformer(CamelContext var1) throws Exception;

    static {
        HashMap map = new HashMap();
        map.put(CustomTransformerDefinition.class, CustomTransformeReifier::new);
        map.put(DataFormatTransformerDefinition.class, DataFormatTransformeReifier::new);
        map.put(EndpointTransformerDefinition.class, EndpointTransformeReifier::new);
        TRANSFORMERS = map;
    }
}

