/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.StringHelper;

public class DeadLetterChannelReifier
extends DefaultErrorHandlerReifier<DeadLetterChannelBuilder> {
    public DeadLetterChannelReifier(ErrorHandlerFactory definition) {
        super((DeadLetterChannelBuilder)definition);
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        this.validateDeadLetterUri(routeContext);
        DeadLetterChannel answer = new DeadLetterChannel(routeContext.getCamelContext(), processor, ((DeadLetterChannelBuilder)this.definition).getLogger(), ((DeadLetterChannelBuilder)this.definition).getOnRedelivery(), ((DeadLetterChannelBuilder)this.definition).getRedeliveryPolicy(), ((DeadLetterChannelBuilder)this.definition).getExceptionPolicyStrategy(), ((DeadLetterChannelBuilder)this.definition).getFailureProcessor(), ((DeadLetterChannelBuilder)this.definition).getDeadLetterUri(), ((DeadLetterChannelBuilder)this.definition).isDeadLetterHandleNewException(), ((DeadLetterChannelBuilder)this.definition).isUseOriginalMessage(), ((DeadLetterChannelBuilder)this.definition).isUseOriginalBody(), ((DeadLetterChannelBuilder)this.definition).getRetryWhilePolicy(routeContext.getCamelContext()), this.getExecutorService(routeContext.getCamelContext()), ((DeadLetterChannelBuilder)this.definition).getOnPrepareFailure(), ((DeadLetterChannelBuilder)this.definition).getOnExceptionOccurred());
        this.configure(routeContext, (ErrorHandler)answer);
        return answer;
    }

    protected void validateDeadLetterUri(RouteContext routeContext) {
        Endpoint deadLetter = ((DeadLetterChannelBuilder)this.definition).getDeadLetter();
        String deadLetterUri = ((DeadLetterChannelBuilder)this.definition).getDeadLetterUri();
        if (deadLetter == null) {
            StringHelper.notEmpty((String)deadLetterUri, (String)"deadLetterUri", (Object)this);
            deadLetter = routeContext.getCamelContext().getEndpoint(deadLetterUri);
            if (deadLetter == null) {
                throw new NoSuchEndpointException(deadLetterUri);
            }
            ((DeadLetterChannelBuilder)this.definition).setDeadLetter(deadLetter);
        }
    }
}

