/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.YAMLLibrary;
import org.apache.camel.model.dataformat.YAMLTypeFilterDefinition;
import org.apache.camel.model.dataformat.YAMLTypeFilterType;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public class YAMLDataFormatReifier
extends DataFormatReifier<YAMLDataFormat> {
    public YAMLDataFormatReifier(DataFormatDefinition definition) {
        super((YAMLDataFormat)definition);
    }

    @Override
    protected DataFormat doCreateDataFormat(CamelContext camelContext) {
        if (((YAMLDataFormat)this.definition).getLibrary() == YAMLLibrary.SnakeYAML) {
            this.setProperty(camelContext, this, "dataFormatName", (Object)"yaml-snakeyaml");
        }
        return super.doCreateDataFormat(camelContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (((YAMLDataFormat)this.definition).getLibrary() == YAMLLibrary.SnakeYAML) {
            this.configureSnakeDataFormat(dataFormat, camelContext);
        }
    }

    protected void configureSnakeDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        Class yamlUnmarshalType = ((YAMLDataFormat)this.definition).getUnmarshalType();
        if (yamlUnmarshalType == null && ((YAMLDataFormat)this.definition).getUnmarshalTypeName() != null) {
            try {
                yamlUnmarshalType = camelContext.getClassResolver().resolveMandatoryClass(((YAMLDataFormat)this.definition).getUnmarshalTypeName());
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        this.setProperty(dataFormat, camelContext, "unmarshalType", yamlUnmarshalType);
        this.setProperty(dataFormat, camelContext, "classLoader", (Object)((YAMLDataFormat)this.definition).getClassLoader());
        this.setProperty(dataFormat, camelContext, "useApplicationContextClassLoader", (Object)((YAMLDataFormat)this.definition).isUseApplicationContextClassLoader());
        this.setProperty(dataFormat, camelContext, "prettyFlow", (Object)((YAMLDataFormat)this.definition).isPrettyFlow());
        this.setProperty(dataFormat, camelContext, "allowAnyType", (Object)((YAMLDataFormat)this.definition).isAllowAnyType());
        if (((YAMLDataFormat)this.definition).getTypeFilters() != null && !((YAMLDataFormat)this.definition).getTypeFilters().isEmpty()) {
            ArrayList<String> typeFilterDefinitions = new ArrayList<String>(((YAMLDataFormat)this.definition).getTypeFilters().size());
            for (YAMLTypeFilterDefinition definition : ((YAMLDataFormat)this.definition).getTypeFilters()) {
                String value = definition.getValue();
                if (!value.startsWith("type") && !value.startsWith("regexp")) {
                    YAMLTypeFilterType type = definition.getType();
                    if (type == null) {
                        type = YAMLTypeFilterType.type;
                    }
                    value = type.name() + ":" + value;
                }
                typeFilterDefinitions.add(value);
            }
            this.setProperty(dataFormat, camelContext, "typeFilterDefinitions", typeFilterDefinitions);
        }
        this.setPropertyRef(dataFormat, camelContext, "constructor", ((YAMLDataFormat)this.definition).getConstructor());
        this.setPropertyRef(dataFormat, camelContext, "representer", ((YAMLDataFormat)this.definition).getRepresenter());
        this.setPropertyRef(dataFormat, camelContext, "dumperOptions", ((YAMLDataFormat)this.definition).getDumperOptions());
        this.setPropertyRef(dataFormat, camelContext, "resolver", ((YAMLDataFormat)this.definition).getResolver());
    }

    protected void setProperty(DataFormat dataFormat, CamelContext camelContext, String propertyName, Object propertyValue) {
        if (ObjectHelper.isNotEmpty((Object)propertyValue)) {
            this.setProperty(camelContext, dataFormat, propertyName, propertyValue);
        }
    }

    protected void setPropertyRef(DataFormat dataFormat, CamelContext camelContext, String propertyName, String propertyValue) {
        if (ObjectHelper.isNotEmpty((Object)propertyValue)) {
            String ref = propertyValue.startsWith("#") ? propertyValue : "#" + propertyValue;
            this.setProperty(camelContext, dataFormat, propertyName, (Object)ref);
        }
    }
}

