/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;

public class RoutingSlipReifier
extends ExpressionReifier<RoutingSlipDefinition<?>> {
    public RoutingSlipReifier(ProcessorDefinition<?> definition) {
        super((RoutingSlipDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = ((RoutingSlipDefinition)this.definition).getExpression().createExpression(routeContext);
        String delimiter = ((RoutingSlipDefinition)this.definition).getUriDelimiter() != null ? ((RoutingSlipDefinition)this.definition).getUriDelimiter() : ",";
        RoutingSlip routingSlip = new RoutingSlip(routeContext.getCamelContext(), expression, delimiter);
        if (((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            routingSlip.setIgnoreInvalidEndpoints(((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints().booleanValue());
        }
        if (((RoutingSlipDefinition)this.definition).getCacheSize() != null) {
            routingSlip.setCacheSize(((RoutingSlipDefinition)this.definition).getCacheSize().intValue());
        }
        ErrorHandlerFactory builder = routeContext.getErrorHandlerFactory();
        AsyncProcessor errorHandler = (AsyncProcessor)ErrorHandlerReifier.reifier(builder).createErrorHandler(routeContext, (Processor)routingSlip.newRoutingSlipProcessorForErrorHandler());
        routingSlip.setErrorHandler(errorHandler);
        return routingSlip;
    }
}

