/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserFactory;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="serviceChooserConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallServiceChooserConfiguration
extends IdentifiedType
implements ServiceChooserFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;
    @XmlElement(name="properties")
    @Metadata(label="advanced")
    private List<PropertyDefinition> properties;

    public ServiceCallServiceChooserConfiguration() {
        this(null, null);
    }

    public ServiceCallServiceChooserConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public ServiceCallServiceChooserConfiguration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.properties.add(prop);
        return this;
    }

    protected Map<String, String> getPropertiesAsMap(CamelContext camelContext) throws Exception {
        Map<String, String> answer;
        if (this.properties == null || this.properties.isEmpty()) {
            answer = Collections.emptyMap();
        } else {
            answer = new HashMap<String, String>();
            for (PropertyDefinition prop : this.properties) {
                String key = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getKey());
                String value = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    public ServiceChooser newInstance(CamelContext camelContext) throws Exception {
        ServiceChooser answer;
        ObjectHelper.notNull((Object)this.factoryKey, (String)"ServiceChooser factoryKey");
        ServiceChooserFactory factory = (ServiceChooserFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)this.factoryKey, ServiceChooserFactory.class);
        if (factory != null) {
            answer = (ServiceChooser)factory.newInstance(camelContext);
        } else {
            Class type;
            try {
                type = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey).orElse(null);
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, (Throwable)e);
            }
            if (type != null) {
                if (ServiceChooserFactory.class.isAssignableFrom(type)) {
                    factory = (ServiceChooserFactory)camelContext.getInjector().newInstance(type, false);
                } else {
                    throw new NoFactoryAvailableException("Resolving ServiceChooser: " + this.factoryKey + " detected type conflict: Not a ServiceChooserFactory implementation. Found: " + type.getName());
                }
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getProperties((Object)this, parameters, null, false);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        try {
                            v = camelContext.resolvePropertyPlaceholders((String)v);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v.toString()), e);
                        }
                    }
                    return v;
                });
                parameters.put("properties", this.getPropertiesAsMap(camelContext));
                this.postProcessFactoryParameters(camelContext, parameters);
                PropertyBindingSupport.build().bind(camelContext, (Object)factory, parameters);
                answer = (ServiceChooser)factory.newInstance(camelContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }

    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
    }
}

