/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.TransformerBuilder;
import org.apache.camel.builder.ValidatorBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private RestsDefinition restCollection = new RestsDefinition();
    private Map<String, RestConfigurationDefinition> restConfigurations;
    private List<TransformerBuilder> transformerBuilders = new ArrayList<TransformerBuilder>();
    private List<ValidatorBuilder> validatorBuilders = new ArrayList<ValidatorBuilder>();
    private RoutesDefinition routeCollection = new RoutesDefinition();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    public static void addRoutes(CamelContext context, final ThrowingConsumer<RouteBuilder, Exception> rbc) throws Exception {
        context.addRoutes((RoutesBuilder)new RouteBuilder(context){

            @Override
            public void configure() throws Exception {
                rbc.accept((Object)this);
            }
        });
    }

    public String toString() {
        return this.getRouteCollection().toString();
    }

    public abstract void configure() throws Exception;

    public void bindToRegistry(String id, Object bean) {
        this.getContext().getRegistry().bind(id, bean);
    }

    public void bindToRegistry(String id, Class<?> type, Object bean) {
        this.getContext().getRegistry().bind(id, type, bean);
    }

    public RestConfigurationDefinition restConfiguration() {
        return this.restConfiguration("");
    }

    public RestConfigurationDefinition restConfiguration(String component) {
        RestConfigurationDefinition restConfiguration;
        if (this.restConfigurations == null) {
            this.restConfigurations = new HashMap<String, RestConfigurationDefinition>();
        }
        if ((restConfiguration = this.restConfigurations.get(component)) == null) {
            restConfiguration = new RestConfigurationDefinition();
            if (!component.isEmpty()) {
                restConfiguration.component(component);
            }
            this.restConfigurations.put(component, restConfiguration);
        }
        return restConfiguration;
    }

    public RestDefinition rest() {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest();
        this.configureRest(answer);
        return answer;
    }

    public RestDefinition rest(String path) {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest(path);
        this.configureRest(answer);
        return answer;
    }

    public TransformerBuilder transformer() {
        TransformerBuilder tdb = new TransformerBuilder();
        this.transformerBuilders.add(tdb);
        return tdb;
    }

    public ValidatorBuilder validator() {
        ValidatorBuilder vb = new ValidatorBuilder();
        this.validatorBuilders.add(vb);
        return vb;
    }

    public RouteDefinition from(String uri) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(EndpointConsumerBuilder endpointDefinition) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpointDefinition);
        this.configureRoute(answer);
        return answer;
    }

    public void errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        this.setErrorHandlerBuilder(errorHandlerBuilder);
    }

    public <T> T propertyInject(String key, Class<T> type) throws Exception {
        StringHelper.notEmpty((String)key, (String)"key");
        ObjectHelper.notNull(type, (String)"Class type");
        PropertiesComponent pc = this.getContext().getPropertiesComponent();
        Optional value = pc.resolveProperty(key);
        if (value.isPresent()) {
            return (T)this.getContext().getTypeConverter().mandatoryConvertTo(type, value.get());
        }
        return null;
    }

    public InterceptDefinition intercept() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exception) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onException(exception);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class<? extends Throwable> ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class<? extends Throwable>)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onCompletion();
    }

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes(context);
        this.configureRests(context);
        this.populateRests();
        this.populateTransformers();
        this.populateValidators();
        this.populateRoutes();
    }

    public RoutesDefinition configureRoutes(CamelContext context) throws Exception {
        this.setContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public RestsDefinition configureRests(CamelContext context) throws Exception {
        this.setContext(context);
        this.restCollection.setCamelContext(context);
        return this.restCollection;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
        this.getRouteCollection().setErrorHandlerFactory(this.getErrorHandlerBuilder());
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            CamelContext camelContext = this.getContext();
            if (((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory() instanceof ErrorHandlerBuilder) {
                this.setErrorHandlerBuilder((ErrorHandlerBuilder)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory());
            }
            this.configure();
            for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
                route.markPrepared();
            }
        }
    }

    protected void populateRoutes() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteCollection().setCamelContext(camelContext);
        ((Model)camelContext.getExtension(Model.class)).addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    protected void populateRests() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRestCollection().setCamelContext(camelContext);
        if (this.getRestConfigurations() != null) {
            for (Map.Entry<String, RestConfigurationDefinition> entry : this.getRestConfigurations().entrySet()) {
                RestConfiguration config = entry.getValue().asRestConfiguration(this.getContext());
                if ("".equals(entry.getKey())) {
                    camelContext.setRestConfiguration(config);
                    continue;
                }
                camelContext.addRestConfiguration(config);
            }
        }
        ((Model)camelContext.getExtension(Model.class)).addRestDefinitions(this.getRestCollection().getRests(), false);
        for (RestConfiguration config : camelContext.getRestConfigurations()) {
            if (config.getApiContextPath() == null) continue;
            boolean hasRestApi = false;
            for (RouteDefinition route : ((Model)camelContext.getExtension(Model.class)).getRouteDefinitions()) {
                FromDefinition from = route.getInput();
                if (from.getEndpointUri() == null || !from.getEndpointUri().startsWith("rest-api:")) continue;
                hasRestApi = true;
            }
            if (hasRestApi) continue;
            RouteDefinition route = RestDefinition.asRouteApiDefinition(camelContext, config);
            this.log.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
            this.getRouteCollection().route(route);
        }
        this.getRestCollection().getRests().forEach(rest -> rest.asRouteDefinition(this.getContext()).forEach(route -> this.getRouteCollection().route((RouteDefinition)route)));
    }

    protected void populateTransformers() {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        for (TransformerBuilder tdb : this.transformerBuilders) {
            tdb.configure(camelContext);
        }
    }

    protected void populateValidators() {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        for (ValidatorBuilder vb : this.validatorBuilders) {
            vb.configure(camelContext);
        }
    }

    public RestsDefinition getRestCollection() {
        return this.restCollection;
    }

    public Map<String, RestConfigurationDefinition> getRestConfigurations() {
        return this.restConfigurations;
    }

    public void setRestCollection(RestsDefinition restCollection) {
        this.restCollection = restCollection;
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    protected void configureRest(RestDefinition rest) {
    }

    protected void configureRoute(RouteDefinition route) {
    }
}

