/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.builder.AdviceWithBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.AdviceWithTasks;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.InterceptSendToMockEndpointStrategy;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.reifier.RouteReifier;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingConsumer;

public abstract class AdviceWithRouteBuilder
extends RouteBuilder {
    private RouteDefinition originalRoute;
    private final List<AdviceWithTask> adviceWithTasks = new ArrayList<AdviceWithTask>();
    private boolean logRouteAsXml = true;

    public static RouteDefinition adviceWith(CamelContext camelContext, Object routeId, final ThrowingConsumer<AdviceWithRouteBuilder, Exception> builder) throws Exception {
        RouteDefinition rd;
        ModelCamelContext mcc = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
        if (mcc.getRouteDefinitions().isEmpty()) {
            throw new IllegalArgumentException("Cannot advice route as there are no routes");
        }
        String id = (String)mcc.getTypeConverter().convertTo(String.class, routeId);
        if (id != null) {
            Integer num;
            rd = mcc.getRouteDefinition(id);
            if (rd == null && (num = (Integer)mcc.getTypeConverter().tryConvertTo(Integer.class, routeId)) != null) {
                rd = (RouteDefinition)mcc.getRouteDefinitions().get(num);
            }
            if (rd == null) {
                throw new IllegalArgumentException("Cannot advice route as route with id: " + routeId + " does not exists");
            }
        } else {
            rd = (RouteDefinition)mcc.getRouteDefinitions().get(0);
        }
        return RouteReifier.adviceWith(rd, camelContext, new AdviceWithRouteBuilder(){

            @Override
            public void configure() throws Exception {
                builder.accept((Object)this);
            }
        });
    }

    public void setOriginalRoute(RouteDefinition originalRoute) {
        this.originalRoute = originalRoute;
    }

    public RouteDefinition getOriginalRoute() {
        return this.originalRoute;
    }

    public boolean isLogRouteAsXml() {
        return this.logRouteAsXml;
    }

    public void setLogRouteAsXml(boolean logRouteAsXml) {
        this.logRouteAsXml = logRouteAsXml;
    }

    public List<AdviceWithTask> getAdviceWithTasks() {
        return this.adviceWithTasks;
    }

    public void mockEndpoints() throws Exception {
        ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(null));
    }

    public void mockEndpoints(String ... pattern) throws Exception {
        for (String s : pattern) {
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(s));
        }
    }

    public void mockEndpointsAndSkip(String ... pattern) throws Exception {
        for (String s : pattern) {
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(s, true));
        }
    }

    public void replaceFromWith(String uri) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        this.getAdviceWithTasks().add(AdviceWithTasks.replaceFromWith(this.originalRoute, uri));
    }

    public void replaceFromWith(Endpoint endpoint) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        this.getAdviceWithTasks().add(AdviceWithTasks.replaceFrom(this.originalRoute, endpoint));
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveById(String pattern) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder(this, pattern, null, null, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByToString(String pattern) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder(this, null, pattern, null, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByToUri(String pattern) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder(this, null, null, pattern, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByType(Class<T> type) {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder<T>(this, null, null, null, type);
    }

    public <T extends ProcessorDefinition<?>> ProcessorDefinition<?> weaveAddFirst() {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder(this, "*", null, null, null).selectFirst().before();
    }

    public <T extends ProcessorDefinition<?>> ProcessorDefinition<?> weaveAddLast() {
        ObjectHelper.notNull((Object)this.originalRoute, (String)"originalRoute", (Object)this);
        return new AdviceWithBuilder(this, "*", null, null, null).maxDeep(1).selectLast().after();
    }
}

