/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.crypto.DigitalSignatureEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;

public class DigitalSignatureEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return DigitalSignatureEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return DigitalSignatureEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "privateKey": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPrivateKey((PrivateKey)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "keyStoreParameters": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeyStoreParameters((KeyStoreParameters)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyStoreParameters.class, (Object)value));
                return true;
            }
            case "keystore": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeystore((KeyStore)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "secureRandom": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSecureRandom((SecureRandom)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, SecureRandom.class, (Object)value));
                return true;
            }
            case "algorithm": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setAlgorithm((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bufferSize": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setBufferSize((Integer)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "provider": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setProvider((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureHeaderName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSignatureHeaderName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "alias": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setAlias((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPassword((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publicKey": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPublicKey((PublicKey)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, PublicKey.class, (Object)value));
                return true;
            }
            case "certificate": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setCertificate((Certificate)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Certificate.class, (Object)value));
                return true;
            }
            case "publicKeyName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPublicKeyName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "certificateName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setCertificateName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privateKeyName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystoreName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeystoreName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secureRandomName": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSecureRandomName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clearHeaders": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setClearHeaders((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setSynchronous((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "privatekey": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPrivateKey((PrivateKey)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "keystoreparameters": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeyStoreParameters((KeyStoreParameters)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyStoreParameters.class, (Object)value));
                return true;
            }
            case "keystore": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeystore((KeyStore)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "securerandom": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSecureRandom((SecureRandom)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, SecureRandom.class, (Object)value));
                return true;
            }
            case "algorithm": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setAlgorithm((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buffersize": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setBufferSize((Integer)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "provider": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setProvider((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureheadername": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSignatureHeaderName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "alias": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setAlias((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPassword((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publickey": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPublicKey((PublicKey)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, PublicKey.class, (Object)value));
                return true;
            }
            case "certificate": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setCertificate((Certificate)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Certificate.class, (Object)value));
                return true;
            }
            case "publickeyname": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPublicKeyName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "certificatename": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setCertificateName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privatekeyname": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystorename": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setKeystoreName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securerandomname": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setSecureRandomName((String)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clearheaders": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).getConfiguration().setClearHeaders((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setSynchronous((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((DigitalSignatureEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DigitalSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

