/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ExpiredIteratorException;
import com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import com.amazonaws.services.dynamodbv2.model.Record;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.ddbstream.BigIntComparisons;
import org.apache.camel.component.aws.ddbstream.DdbStreamEndpoint;
import org.apache.camel.component.aws.ddbstream.ShardIteratorHandler;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class DdbStreamConsumer
extends ScheduledBatchPollingConsumer {
    private final ShardIteratorHandler shardIteratorHandler;
    private String lastSeenSequenceNumber;

    public DdbStreamConsumer(DdbStreamEndpoint endpoint, Processor processor) {
        this(endpoint, processor, new ShardIteratorHandler(endpoint));
    }

    DdbStreamConsumer(DdbStreamEndpoint endpoint, Processor processor, ShardIteratorHandler shardIteratorHandler) {
        super((Endpoint)endpoint, processor);
        this.shardIteratorHandler = shardIteratorHandler;
    }

    protected int poll() throws Exception {
        GetRecordsResult result;
        try {
            GetRecordsRequest req = new GetRecordsRequest().withShardIterator(this.shardIteratorHandler.getShardIterator(null)).withLimit(Integer.valueOf(this.getEndpoint().getConfiguration().getMaxResultsPerRequest()));
            result = this.getClient().getRecords(req);
        }
        catch (ExpiredIteratorException e) {
            this.log.warn("Expired Shard Iterator, attempting to resume from {}", (Object)this.lastSeenSequenceNumber, (Object)e);
            GetRecordsRequest req = new GetRecordsRequest().withShardIterator(this.shardIteratorHandler.getShardIterator(this.lastSeenSequenceNumber)).withLimit(Integer.valueOf(this.getEndpoint().getConfiguration().getMaxResultsPerRequest()));
            result = this.getClient().getRecords(req);
        }
        List records = result.getRecords();
        Queue<Exchange> exchanges = this.createExchanges(records, this.lastSeenSequenceNumber);
        int processedExchangeCount = this.processBatch(CastUtils.cast(exchanges));
        this.shardIteratorHandler.updateShardIterator(result.getNextShardIterator());
        if (!records.isEmpty()) {
            this.lastSeenSequenceNumber = ((Record)records.get(records.size() - 1)).getDynamodb().getSequenceNumber();
        }
        return processedExchangeCount;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int processedExchanges = 0;
        while (!exchanges.isEmpty()) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            this.log.trace("Processing exchange [{}] started.", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    DdbStreamConsumer.this.log.trace("Processing exchange [{}] done.", (Object)exchange);
                }
            });
            ++processedExchanges;
        }
        return processedExchanges;
    }

    private AmazonDynamoDBStreams getClient() {
        return this.getEndpoint().getClient();
    }

    public DdbStreamEndpoint getEndpoint() {
        return (DdbStreamEndpoint)super.getEndpoint();
    }

    private Queue<Exchange> createExchanges(List<Record> records, String lastSeenSequenceNumber) {
        ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
        BigIntComparisons.Conditions condition = null;
        BigInteger providedSeqNum = null;
        if (lastSeenSequenceNumber != null) {
            providedSeqNum = new BigInteger(lastSeenSequenceNumber);
            condition = BigIntComparisons.Conditions.LT;
        }
        switch (this.getEndpoint().getConfiguration().getIteratorType()) {
            case AFTER_SEQUENCE_NUMBER: {
                condition = BigIntComparisons.Conditions.LT;
                providedSeqNum = new BigInteger(this.getEndpoint().getConfiguration().getSequenceNumberProvider().getSequenceNumber());
                break;
            }
            case AT_SEQUENCE_NUMBER: {
                condition = BigIntComparisons.Conditions.LTEQ;
                providedSeqNum = new BigInteger(this.getEndpoint().getConfiguration().getSequenceNumberProvider().getSequenceNumber());
                break;
            }
        }
        for (Record record : records) {
            BigInteger recordSeqNum = new BigInteger(record.getDynamodb().getSequenceNumber());
            if (condition != null && !condition.matches(providedSeqNum, recordSeqNum)) continue;
            exchanges.add(this.getEndpoint().createExchange(record));
        }
        return exchanges;
    }
}

