/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.ddb.DdbEndpoint;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DdbEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return DdbEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return DdbEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "accessKey": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonDDBClient": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setAmazonDDBClient((AmazonDynamoDB)DdbEndpointConfigurer.property((CamelContext)camelContext, AmazonDynamoDB.class, (Object)value));
                return true;
            }
            case "consistentRead": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setConsistentRead((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setOperation((DdbOperations)((Object)DdbEndpointConfigurer.property((CamelContext)camelContext, DdbOperations.class, (Object)value)));
                return true;
            }
            case "readCapacity": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setReadCapacity((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "writeCapacity": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setWriteCapacity((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "keyAttributeName": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setKeyAttributeName((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyAttributeType": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setKeyAttributeType((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((DdbEndpoint)((Object)endpoint)).setStartScheduler((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((DdbEndpoint)((Object)endpoint)).setInitialDelay((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((DdbEndpoint)((Object)endpoint)).setDelay((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((DdbEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)DdbEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((DdbEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((DdbEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)DdbEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((DdbEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)DdbEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((DdbEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((DdbEndpoint)((Object)endpoint)).setGreedy((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((DdbEndpoint)((Object)endpoint)).setScheduler((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((DdbEndpoint)((Object)endpoint)).setSchedulerProperties((Map)DdbEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((DdbEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)DdbEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((DdbEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((DdbEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((DdbEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DdbEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((DdbEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DdbEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DdbEndpoint)((Object)endpoint)).setSynchronous((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((DdbEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "accesskey": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonddbclient": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setAmazonDDBClient((AmazonDynamoDB)DdbEndpointConfigurer.property((CamelContext)camelContext, AmazonDynamoDB.class, (Object)value));
                return true;
            }
            case "consistentread": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setConsistentRead((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setOperation((DdbOperations)((Object)DdbEndpointConfigurer.property((CamelContext)camelContext, DdbOperations.class, (Object)value)));
                return true;
            }
            case "readcapacity": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setReadCapacity((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "writecapacity": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setWriteCapacity((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "keyattributename": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setKeyAttributeName((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyattributetype": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setKeyAttributeType((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((DdbEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((DdbEndpoint)((Object)endpoint)).setStartScheduler((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((DdbEndpoint)((Object)endpoint)).setInitialDelay((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((DdbEndpoint)((Object)endpoint)).setDelay((Long)DdbEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((DdbEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)DdbEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((DdbEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((DdbEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)DdbEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((DdbEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)DdbEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((DdbEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((DdbEndpoint)((Object)endpoint)).setGreedy((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((DdbEndpoint)((Object)endpoint)).setScheduler((String)DdbEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((DdbEndpoint)((Object)endpoint)).setSchedulerProperties((Map)DdbEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((DdbEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)DdbEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((DdbEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)DdbEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((DdbEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((DdbEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((DdbEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DdbEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((DdbEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DdbEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DdbEndpoint)((Object)endpoint)).setSynchronous((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((DdbEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DdbEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

