/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class KubernetesHPAProducer
extends DefaultProducer {
    public KubernetesHPAProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listHPA": {
                this.doList(exchange, operation);
                break;
            }
            case "listHPAByLabels": {
                this.doListHPAByLabel(exchange, operation);
                break;
            }
            case "getHPA": {
                this.doGetHPA(exchange, operation);
                break;
            }
            case "createHPA": {
                this.doCreateHPA(exchange, operation);
                break;
            }
            case "deleteHPA": {
                this.doDeleteHPA(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)hpaList.getItems());
    }

    protected void doListHPAByLabel(Exchange exchange, String operation) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        if (ObjectHelper.isEmpty((Object)labels)) {
            this.log.error("Get HPA by labels require specify a labels set");
            throw new IllegalArgumentException("Get HPA by labels require specify a labels set");
        }
        MixedOperation hpas = this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers();
        for (Map.Entry entry : labels.entrySet()) {
            hpas.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)hpas.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)hpaList.getItems());
    }

    protected void doGetHPA(Exchange exchange, String operation) throws Exception {
        HorizontalPodAutoscaler hpa = null;
        String podName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)podName)) {
            this.log.error("Get a specific hpa require specify an hpa name");
            throw new IllegalArgumentException("Get a specific hpa require specify an hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            this.log.error("Get a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Get a specific hpa require specify a namespace name");
        }
        hpa = (HorizontalPodAutoscaler)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(podName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)hpa);
    }

    protected void doCreateHPA(Exchange exchange, String operation) throws Exception {
        HorizontalPodAutoscaler hpa = null;
        String hpaName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HorizontalPodAutoscalerSpec hpaSpec = (HorizontalPodAutoscalerSpec)exchange.getIn().getHeader("CamelKubernetesHPASpec", HorizontalPodAutoscalerSpec.class);
        if (ObjectHelper.isEmpty((Object)hpaName)) {
            this.log.error("Create a specific hpa require specify a hpa name");
            throw new IllegalArgumentException("Create a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            this.log.error("Create a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Create a specific hpa require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)hpaSpec)) {
            this.log.error("Create a specific hpa require specify a hpa spec bean");
            throw new IllegalArgumentException("Create a specific hpa require specify a hpa spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        HorizontalPodAutoscaler hpaCreating = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(hpaName)).withLabels(labels)).endMetadata()).withSpec(hpaSpec)).build();
        hpa = (HorizontalPodAutoscaler)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers().inNamespace(namespaceName)).create((Object[])new HorizontalPodAutoscaler[]{hpaCreating});
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)hpa);
    }

    protected void doDeleteHPA(Exchange exchange, String operation) throws Exception {
        String hpaName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)hpaName)) {
            this.log.error("Delete a specific hpa require specify a hpa name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            this.log.error("Delete a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a namespace name");
        }
        boolean hpaDeleted = (Boolean)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(hpaName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)hpaDeleted);
    }
}

