/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.component.mongodb.MongoAbstractConsumerThread;
import org.apache.camel.component.mongodb.MongoDbChangeStreamsConsumer;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.bson.BsonDocument;
import org.bson.Document;

class MongoDbChangeStreamsThread
extends MongoAbstractConsumerThread {
    private List<BsonDocument> bsonFilter;
    private BsonDocument resumeToken;

    MongoDbChangeStreamsThread(MongoDbEndpoint endpoint, MongoDbChangeStreamsConsumer consumer, List<BsonDocument> bsonFilter) {
        super(endpoint, (Consumer)consumer);
        this.bsonFilter = bsonFilter;
    }

    @Override
    protected void init() {
        this.cursor = this.initializeCursor();
    }

    protected MongoCursor initializeCursor() {
        ChangeStreamIterable iterable;
        ChangeStreamIterable changeStreamIterable = iterable = this.bsonFilter != null ? this.dbCol.watch(this.bsonFilter) : this.dbCol.watch();
        if (this.resumeToken != null) {
            iterable = iterable.resumeAfter(this.resumeToken);
        }
        MongoCursor cursor = iterable.iterator();
        return cursor;
    }

    @Override
    protected void regeneratingCursor() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Regenerating cursor, waiting {}ms first", (Object)this.cursorRegenerationDelay);
        }
    }

    @Override
    protected void doRun() {
        try {
            while (this.cursor.hasNext() && this.keepRunning) {
                ChangeStreamDocument dbObj = (ChangeStreamDocument)this.cursor.next();
                Exchange exchange = this.endpoint.createMongoDbExchange((Document)dbObj.getFullDocument());
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Sending exchange: {}, ObjectId: {}", (Object)exchange, ((Document)dbObj.getFullDocument()).get((Object)"_id"));
                    }
                    this.consumer.getProcessor().process(exchange);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.resumeToken = dbObj.getResumeToken();
            }
        }
        catch (MongoException e) {
            if (this.keepRunning) {
                throw e;
            }
            this.log.debug("Exception from MongoDB, will regenerate cursor.", (Throwable)e);
        }
    }
}

