/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.util.List;
import java.util.Map;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.xmlsecurity.XmlSignatureEndpoint;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class XmlSignatureEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return XmlSignatureEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return XmlSignatureEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "parentXpath": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentXpath((XPathFilterParameterSpec)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XPathFilterParameterSpec.class, (Object)value));
                return true;
            }
            case "xpathsToIdAttributes": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setXpathsToIdAttributes((List)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "transformMethods": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setTransformMethods((List)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "keyAccessor": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setKeyAccessor((KeyAccessor)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyAccessor.class, (Object)value));
                return true;
            }
            case "canonicalizationMethod": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setCanonicalizationMethod((AlgorithmMethod)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, AlgorithmMethod.class, (Object)value));
                return true;
            }
            case "signatureAlgorithm": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSignatureAlgorithm((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "digestAlgorithm": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setDigestAlgorithm((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "addKeyInfoReference": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setAddKeyInfoReference((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "prefixForXmlSignatureNamespace": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPrefixForXmlSignatureNamespace((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentObjectId": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentObjectId((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureId": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSignatureId((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentReferenceUri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentReferenceUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentReferenceType": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentReferenceType((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentLocalName": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentLocalName((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentNamespace": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentNamespace((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "plainText": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPlainText((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "plainTextEncoding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPlainTextEncoding((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "properties": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setProperties((XmlSignatureProperties)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignatureProperties.class, (Object)value));
                return true;
            }
            case "baseUri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setBaseUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cryptoContextProperties": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setCryptoContextProperties((Map)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "disallowDoctypeDecl": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setDisallowDoctypeDecl((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "omitXmlDeclaration": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setOmitXmlDeclaration((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "clearHeaders": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setClearHeaders((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "schemaResourceUri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSchemaResourceUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputXmlEncoding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setOutputXmlEncoding((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uriDereferencer": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setUriDereferencer((URIDereferencer)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, URIDereferencer.class, (Object)value));
                return true;
            }
            case "keySelector": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setKeySelector((KeySelector)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, KeySelector.class, (Object)value));
                return true;
            }
            case "xmlSignatureChecker": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setXmlSignatureChecker((XmlSignatureChecker)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignatureChecker.class, (Object)value));
                return true;
            }
            case "xmlSignature2Message": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setXmlSignature2Message((XmlSignature2Message)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignature2Message.class, (Object)value));
                return true;
            }
            case "validationFailedHandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setValidationFailedHandler((ValidationFailedHandler)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ValidationFailedHandler.class, (Object)value));
                return true;
            }
            case "outputNodeSearch": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setOutputNodeSearch(XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputNodeSearchType": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setOutputNodeSearchType((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "removeSignatureElements": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setRemoveSignatureElements((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "secureValidation": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setSecureValidation((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setSynchronous((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "parentxpath": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentXpath((XPathFilterParameterSpec)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XPathFilterParameterSpec.class, (Object)value));
                return true;
            }
            case "xpathstoidattributes": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setXpathsToIdAttributes((List)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "transformmethods": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setTransformMethods((List)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "keyaccessor": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setKeyAccessor((KeyAccessor)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, KeyAccessor.class, (Object)value));
                return true;
            }
            case "canonicalizationmethod": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setCanonicalizationMethod((AlgorithmMethod)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, AlgorithmMethod.class, (Object)value));
                return true;
            }
            case "signaturealgorithm": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSignatureAlgorithm((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "digestalgorithm": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setDigestAlgorithm((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "addkeyinforeference": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setAddKeyInfoReference((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "prefixforxmlsignaturenamespace": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPrefixForXmlSignatureNamespace((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentobjectid": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentObjectId((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureid": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSignatureId((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentreferenceuri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentReferenceUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentreferencetype": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setContentReferenceType((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentlocalname": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentLocalName((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentnamespace": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setParentNamespace((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "plaintext": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPlainText((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "plaintextencoding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setPlainTextEncoding((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "properties": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setProperties((XmlSignatureProperties)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignatureProperties.class, (Object)value));
                return true;
            }
            case "baseuri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setBaseUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cryptocontextproperties": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setCryptoContextProperties((Map)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "disallowdoctypedecl": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setDisallowDoctypeDecl((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "omitxmldeclaration": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setOmitXmlDeclaration((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "clearheaders": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setClearHeaders((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "schemaresourceuri": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setSchemaResourceUri((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputxmlencoding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setOutputXmlEncoding((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uridereferencer": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getSignerConfiguration().setUriDereferencer((URIDereferencer)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, URIDereferencer.class, (Object)value));
                return true;
            }
            case "keyselector": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setKeySelector((KeySelector)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, KeySelector.class, (Object)value));
                return true;
            }
            case "xmlsignaturechecker": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setXmlSignatureChecker((XmlSignatureChecker)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignatureChecker.class, (Object)value));
                return true;
            }
            case "xmlsignature2message": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setXmlSignature2Message((XmlSignature2Message)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, XmlSignature2Message.class, (Object)value));
                return true;
            }
            case "validationfailedhandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setValidationFailedHandler((ValidationFailedHandler)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ValidationFailedHandler.class, (Object)value));
                return true;
            }
            case "outputnodesearch": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setOutputNodeSearch(XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputnodesearchtype": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setOutputNodeSearchType((String)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "removesignatureelements": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setRemoveSignatureElements((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "securevalidation": {
                ((XmlSignatureEndpoint)((Object)endpoint)).getVerifierConfiguration().setSecureValidation((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setSynchronous((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((XmlSignatureEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)XmlSignatureEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

