/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.filters;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.hbase.filters.ModelAwareFilter;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;

public class ModelAwareFilterList
implements ModelAwareFilter<FilterList> {
    FilterList fl;

    public ModelAwareFilterList() {
        this.fl = new FilterList(new Filter[0]);
    }

    public ModelAwareFilterList(List<Filter> rowFilters) {
        this.fl = new FilterList(rowFilters);
    }

    public ModelAwareFilterList(FilterList.Operator operator) {
        this.fl = new FilterList(operator);
    }

    public ModelAwareFilterList(FilterList.Operator operator, List<Filter> rowFilters) {
        this.fl = new FilterList(operator, rowFilters);
    }

    @Override
    public void apply(CamelContext context, HBaseRow rowModel) {
        for (Filter filter : this.getFilters()) {
            if (!ModelAwareFilter.class.isAssignableFrom(filter.getClass())) continue;
            ((ModelAwareFilter)filter).apply(context, rowModel);
        }
    }

    public static ModelAwareFilterList wrap(FilterList filter) {
        return new ModelAwareFilterList(filter.getOperator(), filter.getFilters());
    }

    public List<Filter> getFilters() {
        return this.fl.getFilters();
    }

    public void addFilter(Filter filter) {
        this.getFilters().add(filter);
    }

    @Override
    public FilterList getFilteredList() {
        return this.fl;
    }
}

