/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;

@Component(value="hbase")
public class HBaseComponent
extends DefaultComponent {
    private Connection connection;
    @Metadata(label="advanced")
    private Configuration configuration;
    @Metadata(defaultValue="10")
    private int poolMaxSize = 10;

    public HBaseComponent() {
    }

    public HBaseComponent(CamelContext context) {
        super(context);
    }

    protected void doStart() throws Exception {
        if (this.configuration == null) {
            this.configuration = HBaseConfiguration.create();
            ClassLoader applicationContextClassLoader = this.getCamelContext().getApplicationContextClassLoader();
            if (applicationContextClassLoader != null) {
                this.configuration.setClassLoader(applicationContextClassLoader);
                HBaseConfiguration.addHbaseResources((Configuration)this.configuration);
            }
        }
        this.connection = ConnectionFactory.createConnection((Configuration)this.configuration, (ExecutorService)Executors.newFixedThreadPool(this.poolMaxSize));
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HBaseEndpoint endpoint = new HBaseEndpoint(uri, this, this.connection, remaining);
        Map mapping = PropertiesHelper.extractProperties(parameters, (String)"row.");
        endpoint.setRowMapping(mapping);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }
}

