/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs.kerberos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosConfiguration.class);
    private static final String HFDS_NAMED_SERVICE = "hfdsNamedService";
    private static final String KERBEROS_5_SYS_ENV = "java.security.krb5.conf";
    private static final String AUTHENTICATION_MODE = "hadoop.security.authentication";
    private static final String HFDS_FS = "fs.defaultFS";

    public KerberosConfiguration(List<String> namedNodes, String kerberosConfigFileLocation, int replicationFactor) {
        KerberosConfiguration.setKerberosConfigFile(kerberosConfigFileLocation);
        this.setupHdfsConfiguration(namedNodes, replicationFactor);
    }

    private void setupHdfsConfiguration(List<String> namedNodes, int replicationFactor) {
        this.set(AUTHENTICATION_MODE, "kerberos");
        this.set("dfs.replication", Integer.toString(replicationFactor));
        this.set("dfs.nameservices", HFDS_NAMED_SERVICE);
        this.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{HFDS_NAMED_SERVICE}), this.nodeToString(namedNodes.stream().map(this::nodeToString).collect(Collectors.joining(","))));
        namedNodes.forEach(nodeName -> this.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{HFDS_NAMED_SERVICE, this.nodeToString((String)nodeName)}), (String)nodeName));
        this.set("dfs.client.failover.proxy.provider.hfdsNamedService", ConfiguredFailoverProxyProvider.class.getName());
        this.set(HFDS_FS, "hdfs://hfdsNamedService");
    }

    public void loginWithKeytab(String username, String keyTabFileLocation) throws IOException {
        if (!new File(keyTabFileLocation).exists()) {
            throw new FileNotFoundException(String.format("KeyTab file [%s] could not be found.", keyTabFileLocation));
        }
        UserGroupInformation.setConfiguration((Configuration)this);
        UserGroupInformation.loginUserFromKeytab((String)username, (String)keyTabFileLocation);
    }

    public static void setKerberosConfigFile(String kerberosConfigFileLocation) {
        if (!new File(kerberosConfigFileLocation).exists()) {
            LOG.warn("Kerberos configuration file [{}}] could not be found.", (Object)kerberosConfigFileLocation);
            return;
        }
        String krb5Conf = System.getProperty(KERBEROS_5_SYS_ENV);
        if (krb5Conf == null || !krb5Conf.isEmpty()) {
            System.setProperty(KERBEROS_5_SYS_ENV, kerberosConfigFileLocation);
        } else if (!krb5Conf.equalsIgnoreCase(kerberosConfigFileLocation)) {
            LOG.warn("[{}] was already configured with: [{}] config file", (Object)KERBEROS_5_SYS_ENV, (Object)krb5Conf);
        }
    }

    private String nodeToString(String nodeName) {
        return nodeName.replaceAll(":[0-9]*", "").replaceAll("\\.", "_");
    }
}

