/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.DefaultHdfsFileType;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;

class HdfsMapFileType
extends DefaultHdfsFileType {
    HdfsMapFileType() {
    }

    @Override
    public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
        try {
            Holder<Integer> keySize = new Holder<Integer>();
            Writable keyWritable = this.getWritable(key, typeConverter, keySize);
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = this.getWritable(value, typeConverter, valueSize);
            ((MapFile.Writer)hdfsostr.getOut()).append((WritableComparable)keyWritable, valueWritable);
            return Long.sum(((Integer)keySize.value).intValue(), ((Integer)valueSize.value).intValue());
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        try {
            MapFile.Reader reader = (MapFile.Reader)hdfsInputStream.getIn();
            Holder<Integer> keySize = new Holder<Integer>();
            WritableComparable keyWritable = (WritableComparable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)new Configuration());
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
            if (reader.next(keyWritable, valueWritable)) {
                key.value = this.getObject((Writable)keyWritable, keySize);
                value.value = this.getObject(valueWritable, valueSize);
                return Long.sum(((Integer)keySize.value).intValue(), ((Integer)valueSize.value).intValue());
            }
            return 0L;
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            Class<? extends WritableComparable> keyWritableClass = configuration.getKeyType().getWritableClass();
            Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
            MapFile.Writer rout = new MapFile.Writer(hdfsInfo.getConf(), new Path(hdfsPath), new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(keyWritableClass), MapFile.Writer.valueClass(valueWritableClass), MapFile.Writer.compression((SequenceFile.CompressionType)configuration.getCompressionType(), (CompressionCodec)configuration.getCompressionCodec().getCodec()), MapFile.Writer.progressable(() -> {})});
            return rout;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            MapFile.Reader rin = new MapFile.Reader(new Path(hdfsPath), hdfsInfo.getConf(), new SequenceFile.Reader.Option[0]);
            return rin;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

