/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsInputStream
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsInputStream.class);
    private HdfsFileType fileType;
    private String actualPath;
    private String suffixedPath;
    private String suffixedReadPath;
    private Closeable in;
    private boolean opened;
    private int chunkSize;
    private final AtomicLong numOfReadBytes = new AtomicLong(0L);
    private final AtomicLong numOfReadMessages = new AtomicLong(0L);
    private HdfsConfiguration config;

    protected HdfsInputStream() {
    }

    public static HdfsInputStream createInputStream(String hdfsPath, HdfsConfiguration configuration) {
        HdfsInputStream ret = new HdfsInputStream();
        ret.fileType = configuration.getFileType();
        ret.actualPath = hdfsPath;
        ret.suffixedPath = ret.actualPath + '.' + configuration.getOpenedSuffix();
        ret.suffixedReadPath = ret.actualPath + '.' + configuration.getReadSuffix();
        ret.chunkSize = configuration.getChunkSize();
        try {
            HdfsInfo info = HdfsInfoFactory.newHdfsInfo(ret.actualPath, configuration);
            if (info.getFileSystem().rename(new Path(ret.actualPath), new Path(ret.suffixedPath))) {
                ret.in = ret.fileType.createInputStream(ret.suffixedPath, configuration);
                ret.opened = true;
                ret.config = configuration;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to open file [{}] because it doesn't exist", (Object)hdfsPath);
                }
                ret = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public final void close() throws IOException {
        if (this.opened) {
            IOUtils.closeStream((Closeable)this.in);
            HdfsInfo info = HdfsInfoFactory.newHdfsInfo(this.actualPath, this.config);
            info.getFileSystem().rename(new Path(this.suffixedPath), new Path(this.suffixedReadPath));
            this.opened = false;
        }
    }

    public final long next(Holder<Object> key, Holder<Object> value) {
        long nb = this.fileType.next(this, key, value);
        if (nb == 0L && this.numOfReadMessages.get() > 0L) {
            return -1L;
        }
        if (value.value != null) {
            this.numOfReadBytes.addAndGet(nb);
            this.numOfReadMessages.incrementAndGet();
            return nb;
        }
        return -1L;
    }

    public final long getNumOfReadBytes() {
        return this.numOfReadBytes.longValue();
    }

    public final long getNumOfReadMessages() {
        return this.numOfReadMessages.longValue();
    }

    public final String getActualPath() {
        return this.actualPath;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final Closeable getIn() {
        return this.in;
    }

    public boolean isOpened() {
        return this.opened;
    }
}

