/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.kerberos.KerberosConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class HdfsInfo {
    private Configuration configuration;
    private FileSystem fileSystem;
    private Path path;

    HdfsInfo(String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        this.configuration = this.newConfiguration(endpointConfig);
        this.fileSystem = this.newFileSystem(this.configuration, hdfsPath, endpointConfig);
        this.path = new Path(hdfsPath);
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Path getPath() {
        return this.path;
    }

    private Configuration newConfiguration(HdfsConfiguration endpointConfig) throws IOException {
        if (endpointConfig.isKerberosAuthentication()) {
            List<String> namedNodes = endpointConfig.getKerberosNamedNodeList();
            String kerberosConfigFileLocation = endpointConfig.getKerberosConfigFileLocation();
            return new KerberosConfiguration(namedNodes, kerberosConfigFileLocation, endpointConfig.getReplication());
        }
        return new Configuration();
    }

    private FileSystem newFileSystem(Configuration configuration, String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        if (endpointConfig.isKerberosAuthentication()) {
            String userName = endpointConfig.getKerberosUsername();
            String keytabLocation = endpointConfig.getKerberosKeytabLocation();
            ((KerberosConfiguration)configuration).loginWithKeytab(userName, keytabLocation);
        }
        return FileSystem.get((URI)URI.create(hdfsPath), (Configuration)configuration);
    }
}

