/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.hdfs.HdfsCompressionCodec;
import org.apache.camel.component.hdfs.HdfsEndpoint;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.WritableType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.hadoop.io.SequenceFile;

public class HdfsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return HdfsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return HdfsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "overwrite": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOverwrite((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "append": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setAppend((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "splitStrategy": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setSplitStrategy((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bufferSize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setBufferSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replication": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setReplication((Short)HdfsEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "blockSize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setBlockSize((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "compressionType": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCompressionType((SequenceFile.CompressionType)HdfsEndpointConfigurer.property((CamelContext)camelContext, SequenceFile.CompressionType.class, (Object)value));
                return true;
            }
            case "compressionCodec": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCompressionCodec((HdfsCompressionCodec)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsCompressionCodec.class, (Object)value)));
                return true;
            }
            case "fileType": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setFileType((HdfsFileType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileType.class, (Object)value)));
                return true;
            }
            case "fileSystemType": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setFileSystemType((HdfsFileSystemType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileSystemType.class, (Object)value)));
                return true;
            }
            case "keyType": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKeyType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "valueType": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setValueType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "openedSuffix": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOpenedSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "readSuffix": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setReadSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pattern": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setPattern((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "chunkSize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setChunkSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "checkIdleInterval": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCheckIdleInterval((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "connectOnStartup": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setConnectOnStartup((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "owner": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOwner((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosNamedNodes": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosNamedNodes((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosConfigFileLocation": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosConfigFileLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosUsername": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosUsername((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosKeytabLocation": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosKeytabLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((HdfsEndpoint)((Object)endpoint)).setStartScheduler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((HdfsEndpoint)((Object)endpoint)).setInitialDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((HdfsEndpoint)((Object)endpoint)).setDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((HdfsEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((HdfsEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((HdfsEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)HdfsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((HdfsEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)HdfsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((HdfsEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((HdfsEndpoint)((Object)endpoint)).setGreedy((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((HdfsEndpoint)((Object)endpoint)).setScheduler((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((HdfsEndpoint)((Object)endpoint)).setSchedulerProperties((Map)HdfsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((HdfsEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)HdfsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((HdfsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((HdfsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((HdfsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((HdfsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((HdfsEndpoint)((Object)endpoint)).setSynchronous((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((HdfsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "overwrite": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOverwrite((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "append": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setAppend((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "splitstrategy": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setSplitStrategy((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buffersize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setBufferSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replication": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setReplication((Short)HdfsEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "blocksize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setBlockSize((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "compressiontype": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCompressionType((SequenceFile.CompressionType)HdfsEndpointConfigurer.property((CamelContext)camelContext, SequenceFile.CompressionType.class, (Object)value));
                return true;
            }
            case "compressioncodec": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCompressionCodec((HdfsCompressionCodec)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsCompressionCodec.class, (Object)value)));
                return true;
            }
            case "filetype": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setFileType((HdfsFileType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileType.class, (Object)value)));
                return true;
            }
            case "filesystemtype": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setFileSystemType((HdfsFileSystemType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileSystemType.class, (Object)value)));
                return true;
            }
            case "keytype": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKeyType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "valuetype": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setValueType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "openedsuffix": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOpenedSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "readsuffix": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setReadSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pattern": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setPattern((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "chunksize": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setChunkSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "checkidleinterval": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setCheckIdleInterval((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "connectonstartup": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setConnectOnStartup((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "owner": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setOwner((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosnamednodes": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosNamedNodes((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosconfigfilelocation": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosConfigFileLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosusername": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosUsername((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberoskeytablocation": {
                ((HdfsEndpoint)((Object)endpoint)).getConfig().setKerberosKeytabLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((HdfsEndpoint)((Object)endpoint)).setStartScheduler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((HdfsEndpoint)((Object)endpoint)).setInitialDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((HdfsEndpoint)((Object)endpoint)).setDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((HdfsEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((HdfsEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((HdfsEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)HdfsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((HdfsEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)HdfsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((HdfsEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((HdfsEndpoint)((Object)endpoint)).setGreedy((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((HdfsEndpoint)((Object)endpoint)).setScheduler((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((HdfsEndpoint)((Object)endpoint)).setSchedulerProperties((Map)HdfsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((HdfsEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)HdfsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((HdfsEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((HdfsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((HdfsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((HdfsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((HdfsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((HdfsEndpoint)((Object)endpoint)).setSynchronous((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((HdfsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

