/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.DefaultHdfsFileType;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

class HdfsArrayFileType
extends DefaultHdfsFileType {
    HdfsArrayFileType() {
    }

    @Override
    public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
        try {
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = this.getWritable(value, typeConverter, valueSize);
            ((ArrayFile.Writer)hdfsostr.getOut()).append(valueWritable);
            return ((Integer)valueSize.value).intValue();
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
        try {
            ArrayFile.Reader reader = (ArrayFile.Reader)hdfsistr.getIn();
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
            if (reader.next(valueWritable) != null) {
                value.value = this.getObject(valueWritable, valueSize);
                return ((Integer)valueSize.value).intValue();
            }
            return 0L;
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
            ArrayFile.Writer rout = new ArrayFile.Writer(hdfsInfo.getConf(), hdfsInfo.getFileSystem(), hdfsPath, valueWritableClass, configuration.getCompressionType(), () -> {});
            return rout;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            ArrayFile.Reader rin = new ArrayFile.Reader(hdfsInfo.getFileSystem(), hdfsPath, hdfsInfo.getConf());
            return rin;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

