/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.ObjectHelper;

public final class ProtobufConverter {
    private final Message defaultInstance;

    private ProtobufConverter(Message defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public static ProtobufConverter create(Message defaultInstance) {
        ObjectHelper.notNull((Object)defaultInstance, (String)"defaultInstance");
        return new ProtobufConverter(defaultInstance);
    }

    public Message toProto(Map<?, ?> inputData) {
        ObjectHelper.notNull(inputData, (String)"inputData");
        Descriptors.Descriptor descriptor = this.defaultInstance.getDescriptorForType();
        Message.Builder target = this.defaultInstance.newBuilderForType();
        return this.convertMapToMessage(descriptor, target, inputData);
    }

    private Message convertMapToMessage(Descriptors.Descriptor descriptor, Message.Builder builder, Map<?, ?> inputData) {
        ObjectHelper.notNull((Object)descriptor, (String)"descriptor");
        ObjectHelper.notNull((Object)builder, (String)"builder");
        ObjectHelper.notNull(inputData, (String)"inputData");
        inputData.forEach((key, value) -> {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(key.toString());
            if (fieldDescriptor != null) {
                if (fieldDescriptor.isRepeated()) {
                    List repeatedValues = ProtobufConverter.castValue(value, List.class, String.format("Not able to cast value to list, make sure you have a list for the repeated field '%s'", fieldDescriptor.getName()));
                    repeatedValues.forEach(repeatedValue -> builder.addRepeatedField(fieldDescriptor, this.getSuitableFieldValue(fieldDescriptor, builder, repeatedValue)));
                } else {
                    builder.setField(fieldDescriptor, this.getSuitableFieldValue(fieldDescriptor, builder, value));
                }
            }
        });
        return builder.build();
    }

    private Object getSuitableFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder, Object inputValue) {
        ObjectHelper.notNull((Object)fieldDescriptor, (String)"fieldDescriptor");
        ObjectHelper.notNull((Object)builder, (String)"builder");
        ObjectHelper.notNull((Object)inputValue, (String)"inputValue");
        switch (fieldDescriptor.getJavaType()) {
            case ENUM: {
                return this.getEnumValue(fieldDescriptor, inputValue);
            }
            case MESSAGE: {
                Map nestedValue = ProtobufConverter.castValue(inputValue, Map.class, String.format("Not able to cast value to map, make sure you have a map for the nested field message '%s'", fieldDescriptor.getName()));
                return this.convertMapToMessage(fieldDescriptor.getMessageType(), builder.newBuilderForField(fieldDescriptor), nestedValue);
            }
        }
        return inputValue;
    }

    private Descriptors.EnumValueDescriptor getEnumValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        Descriptors.EnumValueDescriptor enumValueDescriptor = this.getSuitableEnumValue(fieldDescriptor, value);
        if (enumValueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Could not retrieve enum index '%s' for enum field '%s', most likely the index does not exist in the enum indexes '%s'", value, fieldDescriptor.getName(), fieldDescriptor.getEnumType().getValues()));
        }
        return enumValueDescriptor;
    }

    private Descriptors.EnumValueDescriptor getSuitableEnumValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        if (value instanceof String) {
            return fieldDescriptor.getEnumType().findValueByName((String)value);
        }
        int index = ProtobufConverter.castValue(value, Integer.class, String.format("Not able to cast value to integer, make sure you have an integer index for the enum field '%s'", fieldDescriptor.getName()));
        return fieldDescriptor.getEnumType().findValueByNumber(index);
    }

    private static <T> T castValue(Object value, Class<T> type, String errorMessage) {
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
    }
}

