/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.AbstractRedisProcessorCreator;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;

public final class SortedSetsRedisProcessorsCreator
extends AbstractRedisProcessorCreator {
    Map<Command, Processor> getProcessors(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.bind(Command.ZADD, this.wrap(exchange -> redisClient.zadd(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange), exchangeConverter.getScore((Exchange)exchange))));
        this.bind(Command.ZCARD, this.wrap(exchange -> redisClient.zcard(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.ZCOUNT, this.wrap(exchange -> redisClient.zcount(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getMin((Exchange)exchange), exchangeConverter.getMax((Exchange)exchange))));
        this.bind(Command.ZINCRBY, this.wrap(exchange -> redisClient.zincrby(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange), exchangeConverter.getIncrement((Exchange)exchange))));
        this.bind(Command.ZINTERSTORE, exchange -> redisClient.zinterstore(exchangeConverter.getKey(exchange), exchangeConverter.getKeys(exchange), exchangeConverter.getDestination(exchange)));
        this.bind(Command.ZRANGE, this.wrap(exchange -> redisClient.zrange(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getStart((Exchange)exchange), exchangeConverter.getEnd((Exchange)exchange), exchangeConverter.getWithScore((Exchange)exchange))));
        this.bind(Command.ZRANGEBYSCORE, this.wrap(exchange -> redisClient.zrangebyscore(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getMin((Exchange)exchange), exchangeConverter.getMax((Exchange)exchange))));
        this.bind(Command.ZRANK, this.wrap(exchange -> redisClient.zrank(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.ZREM, this.wrap(exchange -> redisClient.zrem(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.ZREMRANGEBYRANK, exchange -> redisClient.zremrangebyrank(exchangeConverter.getKey(exchange), exchangeConverter.getStart(exchange), exchangeConverter.getEnd(exchange)));
        this.bind(Command.ZREMRANGEBYSCORE, exchange -> redisClient.zremrangebyscore(exchangeConverter.getKey(exchange), exchangeConverter.getStart(exchange), exchangeConverter.getEnd(exchange)));
        this.bind(Command.ZREVRANGE, this.wrap(exchange -> redisClient.zrevrange(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getStart((Exchange)exchange), exchangeConverter.getEnd((Exchange)exchange), exchangeConverter.getWithScore((Exchange)exchange))));
        this.bind(Command.ZREVRANGEBYSCORE, this.wrap(exchange -> redisClient.zrevrangebyscore(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getMin((Exchange)exchange), exchangeConverter.getMax((Exchange)exchange))));
        this.bind(Command.ZREVRANK, this.wrap(exchange -> redisClient.zrevrank(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.ZUNIONSTORE, exchange -> redisClient.zunionstore(exchangeConverter.getKey(exchange), exchangeConverter.getKeys(exchange), exchangeConverter.getDestination(exchange)));
        return this.result;
    }
}

