/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.jsse.KeyStoreParameters;

@UriParams
public abstract class DefaultCryptoCmsConfiguration {
    @UriParam(label="common")
    private KeyStoreParameters keyStoreParameters;
    @UriParam(label="common")
    private KeyStore keyStore;

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
        if (keyStoreParameters != null) {
            try {
                this.keyStore = keyStoreParameters.createKeyStore();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Problem during generating the keystore", e);
            }
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStoreParameters getKeyStoreParameters() {
        return this.keyStoreParameters;
    }
}

