/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import java.net.URI;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mqtt.MQTTEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.mqtt.client.QoS;

public class MQTTEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return MQTTEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return MQTTEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "host": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setHost((URI)MQTTEndpointConfigurer.property((CamelContext)camelContext, URI.class, (Object)value));
                return true;
            }
            case "localAddress": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setLocalAddress((URI)MQTTEndpointConfigurer.property((CamelContext)camelContext, URI.class, (Object)value));
                return true;
            }
            case "sslContext": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSslContext((SSLContext)MQTTEndpointConfigurer.property((CamelContext)camelContext, SSLContext.class, (Object)value));
                return true;
            }
            case "dispatchQueue": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setDispatchQueue((DispatchQueue)MQTTEndpointConfigurer.property((CamelContext)camelContext, DispatchQueue.class, (Object)value));
                return true;
            }
            case "blockingExecutor": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setBlockingExecutor((Executor)MQTTEndpointConfigurer.property((CamelContext)camelContext, Executor.class, (Object)value));
                return true;
            }
            case "maxReadRate": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMaxReadRate((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxWriteRate": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMaxWriteRate((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "trafficClass": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setTrafficClass((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receiveBufferSize": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferSize((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "sendBufferSize": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSendBufferSize((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "reconnectDelay": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectDelay((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reconnectDelayMax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectDelayMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reconnectBackOffMultiplier": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackOffMultiplier((Double)MQTTEndpointConfigurer.property((CamelContext)camelContext, Double.TYPE, (Object)value));
                return true;
            }
            case "reconnectAttemptsMax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectAttemptsMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "connectAttemptsMax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setConnectAttemptsMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "clientId": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setClientId((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cleanSession": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setCleanSession((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keepAlive": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setKeepAlive((Short)MQTTEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "willTopic": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillTopic((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "willMessage": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillMessage((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "willQos": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillQos((QoS)MQTTEndpointConfigurer.property((CamelContext)camelContext, QoS.class, (Object)value));
                return true;
            }
            case "willRetain": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillRetain((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "version": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setVersion((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazySessionCreation": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setLazySessionCreation((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mqttTopicPropertyName": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttTopicPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "mqttRetainPropertyName": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttRetainPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "mqttQosPropertyName": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttQosPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribeTopicName": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSubscribeTopicName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribeTopicNames": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSubscribeTopicNames((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publishTopicName": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setPublishTopicName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connectWaitInSeconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setConnectWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "disconnectWaitInSeconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setDisconnectWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "sendWaitInSeconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSendWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "byDefaultRetain": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setByDefaultRetain((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "qualityOfService": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setQualityOfService((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((MQTTEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((MQTTEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((MQTTEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MQTTEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((MQTTEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MQTTEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MQTTEndpoint)((Object)endpoint)).setSynchronous((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((MQTTEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "host": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setHost((URI)MQTTEndpointConfigurer.property((CamelContext)camelContext, URI.class, (Object)value));
                return true;
            }
            case "localaddress": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setLocalAddress((URI)MQTTEndpointConfigurer.property((CamelContext)camelContext, URI.class, (Object)value));
                return true;
            }
            case "sslcontext": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSslContext((SSLContext)MQTTEndpointConfigurer.property((CamelContext)camelContext, SSLContext.class, (Object)value));
                return true;
            }
            case "dispatchqueue": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setDispatchQueue((DispatchQueue)MQTTEndpointConfigurer.property((CamelContext)camelContext, DispatchQueue.class, (Object)value));
                return true;
            }
            case "blockingexecutor": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setBlockingExecutor((Executor)MQTTEndpointConfigurer.property((CamelContext)camelContext, Executor.class, (Object)value));
                return true;
            }
            case "maxreadrate": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMaxReadRate((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxwriterate": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMaxWriteRate((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "trafficclass": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setTrafficClass((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersize": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferSize((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "sendbuffersize": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSendBufferSize((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "reconnectdelay": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectDelay((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reconnectdelaymax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectDelayMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reconnectbackoffmultiplier": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackOffMultiplier((Double)MQTTEndpointConfigurer.property((CamelContext)camelContext, Double.TYPE, (Object)value));
                return true;
            }
            case "reconnectattemptsmax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setReconnectAttemptsMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "connectattemptsmax": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setConnectAttemptsMax((Long)MQTTEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "clientid": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setClientId((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cleansession": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setCleanSession((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keepalive": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setKeepAlive((Short)MQTTEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "willtopic": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillTopic((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "willmessage": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillMessage((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "willqos": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillQos((QoS)MQTTEndpointConfigurer.property((CamelContext)camelContext, QoS.class, (Object)value));
                return true;
            }
            case "willretain": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setWillRetain((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "version": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setVersion((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazysessioncreation": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setLazySessionCreation((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mqtttopicpropertyname": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttTopicPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "mqttretainpropertyname": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttRetainPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "mqttqospropertyname": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setMqttQosPropertyName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribetopicname": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSubscribeTopicName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribetopicnames": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSubscribeTopicNames((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publishtopicname": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setPublishTopicName((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connectwaitinseconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setConnectWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "disconnectwaitinseconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setDisconnectWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "sendwaitinseconds": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setSendWaitInSeconds((Integer)MQTTEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bydefaultretain": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setByDefaultRetain((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "qualityofservice": {
                ((MQTTEndpoint)((Object)endpoint)).getConfiguration().setQualityOfService((String)MQTTEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((MQTTEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((MQTTEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((MQTTEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MQTTEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((MQTTEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MQTTEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MQTTEndpoint)((Object)endpoint)).setSynchronous((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((MQTTEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MQTTEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

