/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.olingo4.Olingo4AppWrapper;
import org.apache.camel.component.olingo4.Olingo4Configuration;
import org.apache.camel.component.olingo4.Olingo4Endpoint;
import org.apache.camel.component.olingo4.api.Olingo4App;
import org.apache.camel.component.olingo4.api.impl.Olingo4AppImpl;
import org.apache.camel.component.olingo4.internal.Olingo4ApiCollection;
import org.apache.camel.component.olingo4.internal.Olingo4ApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;

@Component(value="olingo4")
public class Olingo4Component
extends AbstractApiComponent<Olingo4ApiName, Olingo4Configuration, Olingo4ApiCollection>
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    private Olingo4AppWrapper apiProxy;

    public Olingo4Component() {
        super(Olingo4Endpoint.class, Olingo4ApiName.class, (ApiCollection)Olingo4ApiCollection.getCollection());
    }

    public Olingo4Component(CamelContext context) {
        super(context, Olingo4Endpoint.class, Olingo4ApiName.class, (ApiCollection)Olingo4ApiCollection.getCollection());
    }

    protected Olingo4ApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return Olingo4ApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] pathSegments = remaining.split("/", -1);
        String methodName = pathSegments[0];
        if (pathSegments.length > 1) {
            StringBuilder resourcePath = new StringBuilder();
            for (int i = 1; i < pathSegments.length; ++i) {
                resourcePath.append(pathSegments[i]);
                if (i >= pathSegments.length - 1) continue;
                resourcePath.append('/');
            }
            parameters.put("resourcePath", resourcePath.toString());
        }
        Olingo4Configuration endpointConfiguration = (Olingo4Configuration)this.createEndpointConfiguration(Olingo4ApiName.DEFAULT);
        Endpoint endpoint = this.createEndpoint(uri, methodName, Olingo4ApiName.DEFAULT, endpointConfiguration);
        this.setProperties(endpoint, parameters);
        endpoint.configureProperties(parameters);
        return endpoint;
    }

    protected Endpoint createEndpoint(String uri, String methodName, Olingo4ApiName apiName, Olingo4Configuration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new Olingo4Endpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public void setConfiguration(Olingo4Configuration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public Olingo4Configuration getConfiguration() {
        return (Olingo4Configuration)super.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Olingo4AppWrapper createApiProxy(Olingo4Configuration endpointConfiguration) {
        Olingo4AppWrapper result;
        if (endpointConfiguration.equals(this.configuration)) {
            Olingo4Component olingo4Component = this;
            synchronized (olingo4Component) {
                if (this.apiProxy == null) {
                    this.apiProxy = this.createOlingo4App((Olingo4Configuration)this.configuration);
                }
            }
            result = this.apiProxy;
        } else {
            result = this.createOlingo4App(endpointConfiguration);
        }
        return result;
    }

    private Olingo4AppWrapper createOlingo4App(Olingo4Configuration configuration) {
        HttpAsyncClientBuilder clientBuilder = configuration.getHttpAsyncClientBuilder();
        if (clientBuilder == null) {
            HttpAsyncClientBuilder asyncClientBuilder = HttpAsyncClientBuilder.create();
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setConnectTimeout(configuration.getConnectTimeout());
            requestConfigBuilder.setSocketTimeout(configuration.getSocketTimeout());
            HttpHost proxy = configuration.getProxy();
            if (proxy != null) {
                requestConfigBuilder.setProxy(proxy);
            }
            asyncClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            SSLContextParameters sslContextParameters = configuration.getSslContextParameters();
            if (sslContextParameters == null) {
                sslContextParameters = this.retrieveGlobalSslContextParameters();
            }
            if (sslContextParameters == null) {
                sslContextParameters = new SSLContextParameters();
            }
            try {
                asyncClientBuilder.setSSLContext(sslContextParameters.createSSLContext(this.getCamelContext()));
            }
            catch (GeneralSecurityException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            catch (IOException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            clientBuilder = asyncClientBuilder;
        }
        Olingo4AppImpl olingo4App = clientBuilder == null || clientBuilder instanceof HttpAsyncClientBuilder ? new Olingo4AppImpl(configuration.getServiceUri(), clientBuilder) : new Olingo4AppImpl(configuration.getServiceUri(), (HttpClientBuilder)clientBuilder);
        this.apiProxy = new Olingo4AppWrapper((Olingo4App)olingo4App);
        this.apiProxy.getOlingo4App().setContentType(configuration.getContentType());
        this.apiProxy.getOlingo4App().setHttpHeaders(configuration.getHttpHeaders());
        return this.apiProxy;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public void closeApiProxy(Olingo4AppWrapper apiProxy) {
        if (this.apiProxy != apiProxy) {
            apiProxy.close();
        }
    }

    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            this.apiProxy.close();
        }
    }
}

