/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.RestConsumerFactory;

public final class WebhookUtils {
    private static final String[] DEFAULT_REST_CONSUMER_COMPONENTS = new String[]{"coap", "netty-http", "jetty", "restlet", "servlet", "undertow"};

    private WebhookUtils() {
    }

    public static RestConsumerFactory locateRestConsumerFactory(CamelContext context, WebhookConfiguration configuration) {
        Set factories;
        RestConsumerFactory factory = null;
        if (configuration.getWebhookComponentName() != null) {
            Component comp = context.getRegistry().lookupByName(configuration.getWebhookComponentName());
            if (comp instanceof RestConsumerFactory) {
                factory = (RestConsumerFactory)comp;
            } else {
                comp = context.getComponent(configuration.getWebhookComponentName());
                if (comp instanceof RestConsumerFactory) {
                    factory = (RestConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + configuration.getWebhookComponentName() + " is not a RestConsumerFactory");
                }
                throw new NoSuchBeanException(configuration.getWebhookComponentName(), RestConsumerFactory.class.getName());
            }
        }
        if (factory == null) {
            for (String name : context.getComponentNames()) {
                Component comp = context.getComponent(name);
                if (!(comp instanceof RestConsumerFactory)) continue;
                factory = (RestConsumerFactory)comp;
                break;
            }
        }
        if (factory == null && (factories = context.getRegistry().findByType(RestConsumerFactory.class)) != null && factories.size() == 1) {
            factory = (RestConsumerFactory)factories.iterator().next();
        }
        if (factory == null) {
            RestConsumerFactory found = null;
            for (String name : DEFAULT_REST_CONSUMER_COMPONENTS) {
                Component comp = context.getComponent(name, true);
                if (!(comp instanceof RestConsumerFactory)) continue;
                if (found == null) {
                    found = (RestConsumerFactory)comp;
                    continue;
                }
                throw new IllegalArgumentException("Multiple RestConsumerFactory found on classpath. Configure explicit which component to use");
            }
            if (found != null) {
                factory = found;
            }
        }
        if (factory == null) {
            throw new IllegalStateException("Cannot find RestConsumerFactory in Registry or as a Component to use");
        }
        return factory;
    }
}

