/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.event.notifier.route;

import org.apache.camel.CamelContext;
import org.apache.camel.component.microprofile.metrics.event.notifier.AbstractMicroProfileMetricsEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.route.MicroProfileMetricsRouteEventNotifierNamingStrategy;
import org.apache.camel.component.microprofile.metrics.gauge.AtomicIntegerGauge;
import org.apache.camel.spi.CamelEvent;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsRouteEventNotifier
extends AbstractMicroProfileMetricsEventNotifier<CamelEvent.RouteEvent> {
    private AtomicIntegerGauge routesAdded = new AtomicIntegerGauge();
    private AtomicIntegerGauge routesRunning = new AtomicIntegerGauge();
    private MicroProfileMetricsRouteEventNotifierNamingStrategy namingStrategy = MicroProfileMetricsRouteEventNotifierNamingStrategy.DEFAULT;

    public MicroProfileMetricsRouteEventNotifier() {
        super(CamelEvent.RouteEvent.class);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        CamelContext camelContext = this.getCamelContext();
        MetricRegistry metricRegistry = this.getMetricRegistry();
        Tag[] tags = this.namingStrategy.getTags(camelContext);
        final String routeAddedName = this.namingStrategy.getRouteAddedName();
        final String routeRunningName = this.namingStrategy.getRouteRunningName();
        metricRegistry.removeMatching(new MetricFilter(){

            public boolean matches(MetricID metricID, Metric metric) {
                return metricID.getName().equals(routeAddedName) || metricID.getName().equals(routeRunningName);
            }
        });
        Metadata routesAddedMetadata = new MetadataBuilder().withName(routeAddedName).withDisplayName("Routes count").withDescription("The count of routes.").withType(MetricType.GAUGE).build();
        metricRegistry.register(routesAddedMetadata, (Metric)this.routesAdded, tags);
        Metadata routesRunningMetadata = new MetadataBuilder().withName(routeRunningName).withDisplayName("Routes running count").withDescription("The count of running routes.").withType(MetricType.GAUGE).build();
        metricRegistry.register(routesRunningMetadata, (Metric)this.routesRunning, tags);
    }

    public void notify(CamelEvent event) throws Exception {
        if (this.routesAdded == null || this.routesRunning == null) {
            return;
        }
        if (event.getType().equals((Object)CamelEvent.Type.RouteAdded)) {
            this.routesAdded.increment();
        } else if (event.getType().equals((Object)CamelEvent.Type.RouteRemoved)) {
            this.routesAdded.decrement();
        } else if (event.getType().equals((Object)CamelEvent.Type.RouteStarted)) {
            this.routesRunning.increment();
        } else if (event.getType().equals((Object)CamelEvent.Type.RouteStopped)) {
            this.routesRunning.decrement();
        }
    }

    public MicroProfileMetricsRouteEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicroProfileMetricsRouteEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

