/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.aws.cw.CwEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class CwEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return CwEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return CwEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonCwClient": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setAmazonCwClient((AmazonCloudWatch)CwEndpointConfigurer.property((CamelContext)camelContext, AmazonCloudWatch.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "name": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setName((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setValue((Double)CwEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "unit": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setUnit((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timestamp": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setTimestamp((Date)CwEndpointConfigurer.property((CamelContext)camelContext, Date.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)CwEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((CwEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((CwEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((CwEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)CwEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((CwEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)CwEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((CwEndpoint)((Object)endpoint)).setSynchronous((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((CwEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazoncwclient": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setAmazonCwClient((AmazonCloudWatch)CwEndpointConfigurer.property((CamelContext)camelContext, AmazonCloudWatch.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "name": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setName((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setValue((Double)CwEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "unit": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setUnit((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timestamp": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setTimestamp((Date)CwEndpointConfigurer.property((CamelContext)camelContext, Date.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)CwEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((CwEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)CwEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((CwEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((CwEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((CwEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)CwEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((CwEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)CwEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((CwEndpoint)((Object)endpoint)).setSynchronous((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((CwEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)CwEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

