/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.component.scp.ScpEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ScpEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return ScpEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return ScpEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "useUserKnownHostsFile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUseUserKnownHostsFile((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "knownHostsFile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setKnownHostsFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privateKeyFile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privateKeyBytes": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyBytes((byte[])ScpEndpointConfigurer.property((CamelContext)camelContext, byte[].class, (Object)value));
                return true;
            }
            case "privateKeyFilePassphrase": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyFilePassphrase((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "strictHostKeyChecking": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setStrictHostKeyChecking((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "chmod": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setChmod((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ciphers": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setCiphers((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preferredAuthentications": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPreferredAuthentications((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUsername((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPassword((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connectTimeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setConnectTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "soTimeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setSoTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receiveBufferSize": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferSize((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamDownload": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setStreamDownload((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useList": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUseList((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "ignoreFileNotFoundOrPermissionError": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setIgnoreFileNotFoundOrPermissionError((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnect": {
                ((ScpEndpoint)((Object)endpoint)).setDisconnect((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnectOnBatchComplete": {
                ((ScpEndpoint)((Object)endpoint)).setDisconnectOnBatchComplete((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "fileName": {
                ((ScpEndpoint)((Object)endpoint)).setFileName((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "flatten": {
                ((ScpEndpoint)((Object)endpoint)).setFlatten((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowNullBody": {
                ((ScpEndpoint)((Object)endpoint)).setAllowNullBody((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "jailStartingDirectory": {
                ((ScpEndpoint)((Object)endpoint)).setJailStartingDirectory((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "processStrategy": {
                ((ScpEndpoint)((Object)endpoint)).setProcessStrategy((GenericFileProcessStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileProcessStrategy.class, (Object)value));
                return true;
            }
            case "inProgressRepository": {
                ((ScpEndpoint)((Object)endpoint)).setInProgressRepository((IdempotentRepository)ScpEndpointConfigurer.property((CamelContext)camelContext, IdempotentRepository.class, (Object)value));
                return true;
            }
            case "localWorkDirectory": {
                ((ScpEndpoint)((Object)endpoint)).setLocalWorkDirectory((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noop": {
                ((ScpEndpoint)((Object)endpoint)).setNoop((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "recursive": {
                ((ScpEndpoint)((Object)endpoint)).setRecursive((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delete": {
                ((ScpEndpoint)((Object)endpoint)).setDelete((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "preSort": {
                ((ScpEndpoint)((Object)endpoint)).setPreSort((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxMessagesPerPoll": {
                ((ScpEndpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "eagerMaxMessagesPerPoll": {
                ((ScpEndpoint)((Object)endpoint)).setEagerMaxMessagesPerPoll((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxDepth": {
                ((ScpEndpoint)((Object)endpoint)).setMaxDepth((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "minDepth": {
                ((ScpEndpoint)((Object)endpoint)).setMinDepth((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "include": {
                ((ScpEndpoint)((Object)endpoint)).setInclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "exclude": {
                ((ScpEndpoint)((Object)endpoint)).setExclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "move": {
                ((ScpEndpoint)((Object)endpoint)).setMove((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "moveFailed": {
                ((ScpEndpoint)((Object)endpoint)).setMoveFailed((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preMove": {
                ((ScpEndpoint)((Object)endpoint)).setPreMove((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "moveExistingFileStrategy": {
                ((ScpEndpoint)((Object)endpoint)).setMoveExistingFileStrategy((FileMoveExistingStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, FileMoveExistingStrategy.class, (Object)value));
                return true;
            }
            case "idempotent": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotent((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "idempotentKey": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotentKey((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "idempotentRepository": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotentRepository((IdempotentRepository)ScpEndpointConfigurer.property((CamelContext)camelContext, IdempotentRepository.class, (Object)value));
                return true;
            }
            case "filter": {
                ((ScpEndpoint)((Object)endpoint)).setFilter((GenericFileFilter)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileFilter.class, (Object)value));
                return true;
            }
            case "filterDirectory": {
                ((ScpEndpoint)((Object)endpoint)).setFilterDirectory((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filterFile": {
                ((ScpEndpoint)((Object)endpoint)).setFilterFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "antFilterCaseSensitive": {
                ((ScpEndpoint)((Object)endpoint)).setAntFilterCaseSensitive((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "antInclude": {
                ((ScpEndpoint)((Object)endpoint)).setAntInclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "antExclude": {
                ((ScpEndpoint)((Object)endpoint)).setAntExclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sorter": {
                ((ScpEndpoint)((Object)endpoint)).setSorter((Comparator)ScpEndpointConfigurer.property((CamelContext)camelContext, Comparator.class, (Object)value));
                return true;
            }
            case "sortBy": {
                ((ScpEndpoint)((Object)endpoint)).setSortBy((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shuffle": {
                ((ScpEndpoint)((Object)endpoint)).setShuffle((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLock": {
                ((ScpEndpoint)((Object)endpoint)).setReadLock((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "readLockCheckInterval": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockCheckInterval((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readLockTimeout": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockTimeout((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readLockMarkerFile": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMarkerFile((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLockDeleteOrphanLockFiles": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockDeleteOrphanLockFiles((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLockLoggingLevel": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockLoggingLevel((LoggingLevel)ScpEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "readLockMinLength": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMinLength((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readLockMinAge": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMinAge((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readLockRemoveOnRollback": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockRemoveOnRollback((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLockRemoveOnCommit": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockRemoveOnCommit((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLockIdempotentReleaseDelay": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseDelay((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "readLockIdempotentReleaseAsync": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseAsync((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readLockIdempotentReleaseAsyncPoolSize": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseAsyncPoolSize((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "readLockIdempotentReleaseExecutorService": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseExecutorService((ScheduledExecutorService)ScpEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "exclusiveReadLockStrategy": {
                ((ScpEndpoint)((Object)endpoint)).setExclusiveReadLockStrategy((GenericFileExclusiveReadLockStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileExclusiveReadLockStrategy.class, (Object)value));
                return true;
            }
            case "onCompletionExceptionHandler": {
                ((ScpEndpoint)((Object)endpoint)).setOnCompletionExceptionHandler((ExceptionHandler)ScpEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((ScpEndpoint)((Object)endpoint)).setStartScheduler((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((ScpEndpoint)((Object)endpoint)).setInitialDelay((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((ScpEndpoint)((Object)endpoint)).setDelay((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((ScpEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)ScpEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((ScpEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((ScpEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((ScpEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)ScpEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((ScpEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((ScpEndpoint)((Object)endpoint)).setGreedy((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((ScpEndpoint)((Object)endpoint)).setScheduler((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((ScpEndpoint)((Object)endpoint)).setSchedulerProperties((Map)ScpEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((ScpEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)ScpEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((ScpEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((ScpEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((ScpEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ScpEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((ScpEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ScpEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ScpEndpoint)((Object)endpoint)).setSynchronous((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((ScpEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "useuserknownhostsfile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUseUserKnownHostsFile((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "knownhostsfile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setKnownHostsFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privatekeyfile": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privatekeybytes": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyBytes((byte[])ScpEndpointConfigurer.property((CamelContext)camelContext, byte[].class, (Object)value));
                return true;
            }
            case "privatekeyfilepassphrase": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPrivateKeyFilePassphrase((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "stricthostkeychecking": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setStrictHostKeyChecking((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "chmod": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setChmod((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ciphers": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setCiphers((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preferredauthentications": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPreferredAuthentications((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUsername((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setPassword((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connecttimeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setConnectTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "sotimeout": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setSoTimeout((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersize": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferSize((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamdownload": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setStreamDownload((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uselist": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setUseList((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "ignorefilenotfoundorpermissionerror": {
                ((ScpEndpoint)((Object)endpoint)).getConfiguration().setIgnoreFileNotFoundOrPermissionError((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnect": {
                ((ScpEndpoint)((Object)endpoint)).setDisconnect((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnectonbatchcomplete": {
                ((ScpEndpoint)((Object)endpoint)).setDisconnectOnBatchComplete((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "filename": {
                ((ScpEndpoint)((Object)endpoint)).setFileName((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "flatten": {
                ((ScpEndpoint)((Object)endpoint)).setFlatten((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allownullbody": {
                ((ScpEndpoint)((Object)endpoint)).setAllowNullBody((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "jailstartingdirectory": {
                ((ScpEndpoint)((Object)endpoint)).setJailStartingDirectory((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "processstrategy": {
                ((ScpEndpoint)((Object)endpoint)).setProcessStrategy((GenericFileProcessStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileProcessStrategy.class, (Object)value));
                return true;
            }
            case "inprogressrepository": {
                ((ScpEndpoint)((Object)endpoint)).setInProgressRepository((IdempotentRepository)ScpEndpointConfigurer.property((CamelContext)camelContext, IdempotentRepository.class, (Object)value));
                return true;
            }
            case "localworkdirectory": {
                ((ScpEndpoint)((Object)endpoint)).setLocalWorkDirectory((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noop": {
                ((ScpEndpoint)((Object)endpoint)).setNoop((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "recursive": {
                ((ScpEndpoint)((Object)endpoint)).setRecursive((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delete": {
                ((ScpEndpoint)((Object)endpoint)).setDelete((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "presort": {
                ((ScpEndpoint)((Object)endpoint)).setPreSort((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": {
                ((ScpEndpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "eagermaxmessagesperpoll": {
                ((ScpEndpoint)((Object)endpoint)).setEagerMaxMessagesPerPoll((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxdepth": {
                ((ScpEndpoint)((Object)endpoint)).setMaxDepth((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "mindepth": {
                ((ScpEndpoint)((Object)endpoint)).setMinDepth((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "include": {
                ((ScpEndpoint)((Object)endpoint)).setInclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "exclude": {
                ((ScpEndpoint)((Object)endpoint)).setExclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "move": {
                ((ScpEndpoint)((Object)endpoint)).setMove((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "movefailed": {
                ((ScpEndpoint)((Object)endpoint)).setMoveFailed((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "premove": {
                ((ScpEndpoint)((Object)endpoint)).setPreMove((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "moveexistingfilestrategy": {
                ((ScpEndpoint)((Object)endpoint)).setMoveExistingFileStrategy((FileMoveExistingStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, FileMoveExistingStrategy.class, (Object)value));
                return true;
            }
            case "idempotent": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotent((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "idempotentkey": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotentKey((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "idempotentrepository": {
                ((ScpEndpoint)((Object)endpoint)).setIdempotentRepository((IdempotentRepository)ScpEndpointConfigurer.property((CamelContext)camelContext, IdempotentRepository.class, (Object)value));
                return true;
            }
            case "filter": {
                ((ScpEndpoint)((Object)endpoint)).setFilter((GenericFileFilter)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileFilter.class, (Object)value));
                return true;
            }
            case "filterdirectory": {
                ((ScpEndpoint)((Object)endpoint)).setFilterDirectory((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filterfile": {
                ((ScpEndpoint)((Object)endpoint)).setFilterFile((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "antfiltercasesensitive": {
                ((ScpEndpoint)((Object)endpoint)).setAntFilterCaseSensitive((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "antinclude": {
                ((ScpEndpoint)((Object)endpoint)).setAntInclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "antexclude": {
                ((ScpEndpoint)((Object)endpoint)).setAntExclude((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sorter": {
                ((ScpEndpoint)((Object)endpoint)).setSorter((Comparator)ScpEndpointConfigurer.property((CamelContext)camelContext, Comparator.class, (Object)value));
                return true;
            }
            case "sortby": {
                ((ScpEndpoint)((Object)endpoint)).setSortBy((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shuffle": {
                ((ScpEndpoint)((Object)endpoint)).setShuffle((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlock": {
                ((ScpEndpoint)((Object)endpoint)).setReadLock((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "readlockcheckinterval": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockCheckInterval((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readlocktimeout": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockTimeout((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readlockmarkerfile": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMarkerFile((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlockdeleteorphanlockfiles": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockDeleteOrphanLockFiles((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlocklogginglevel": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockLoggingLevel((LoggingLevel)ScpEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "readlockminlength": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMinLength((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readlockminage": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockMinAge((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "readlockremoveonrollback": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockRemoveOnRollback((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlockremoveoncommit": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockRemoveOnCommit((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlockidempotentreleasedelay": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseDelay((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "readlockidempotentreleaseasync": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseAsync((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "readlockidempotentreleaseasyncpoolsize": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseAsyncPoolSize((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "readlockidempotentreleaseexecutorservice": {
                ((ScpEndpoint)((Object)endpoint)).setReadLockIdempotentReleaseExecutorService((ScheduledExecutorService)ScpEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "exclusivereadlockstrategy": {
                ((ScpEndpoint)((Object)endpoint)).setExclusiveReadLockStrategy((GenericFileExclusiveReadLockStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, GenericFileExclusiveReadLockStrategy.class, (Object)value));
                return true;
            }
            case "oncompletionexceptionhandler": {
                ((ScpEndpoint)((Object)endpoint)).setOnCompletionExceptionHandler((ExceptionHandler)ScpEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((ScpEndpoint)((Object)endpoint)).setStartScheduler((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((ScpEndpoint)((Object)endpoint)).setInitialDelay((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((ScpEndpoint)((Object)endpoint)).setDelay((Long)ScpEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((ScpEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)ScpEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((ScpEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((ScpEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)ScpEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((ScpEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)ScpEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((ScpEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((ScpEndpoint)((Object)endpoint)).setGreedy((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((ScpEndpoint)((Object)endpoint)).setScheduler((String)ScpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((ScpEndpoint)((Object)endpoint)).setSchedulerProperties((Map)ScpEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((ScpEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)ScpEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((ScpEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)ScpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((ScpEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((ScpEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((ScpEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ScpEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((ScpEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ScpEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ScpEndpoint)((Object)endpoint)).setSynchronous((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((ScpEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ScpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

