/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.relational.history.KafkaDatabaseHistory;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MySqlConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mysql";
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private String databaseHostName;
    @UriParam(label="consumer,mysql", defaultValue="3306")
    private int databasePort = 3306;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private String databaseUser;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true, secret=true)
    private String databasePassword;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private String databaseServerName;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private int databaseServerId;
    @UriParam(label="consumer,mysql", defaultValue="io.debezium.relational.history.FileDatabaseHistory")
    private String databaseHistory = DebeziumConstants.DEFAULT_DATABASE_HISTORY;
    @UriParam(label="consumer,mysql")
    private String databaseHistoryFileName;
    @UriParam(label="consumer,mysql")
    private String databaseHistoryKafkaTopic;
    @UriParam(label="consumer,mysql")
    private String databaseHistoryKafkaBootstrapServers;
    @UriParam(label="consumer,mysql")
    private String databaseWhitelist;
    @UriParam(label="consumer,mysql")
    private String databaseBlacklist;
    @UriParam(label="consumer,mysql")
    private String tableWhitelist;
    @UriParam(label="consumer,mysql")
    private String tableBlacklist;
    @UriParam(label="consumer,mysql")
    private String columnBlacklist;
    @UriParam(label="consumer,mysql", defaultValue="adaptive_time_microseconds")
    private String timePrecisionMode = "adaptive_time_microseconds";
    @UriParam(label="consumer,mysql", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,mysql", defaultValue="long")
    private String bigintUnsignedHandlingMode = "long";
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean includeQuery;
    @UriParam(label="consumer,mysql", defaultValue="fail")
    private String eventDeserializationFailureHandlingMode = "fail";
    @UriParam(label="consumer,mysql", defaultValue="fail")
    private String inconsistentSchemaHandlingMode = "fail";
    @UriParam(label="consumer,mysql", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mysql", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mysql", defaultValue="1000")
    private long pollIntervalMs = 1000L;
    @UriParam(label="consumer,mysql", defaultValue="30000")
    private long connectTimeoutMs = 30000L;
    @UriParam(label="consumer,mysql")
    private String gtidSourceIncludes;
    @UriParam(label="consumer,mysql")
    private String gtidSourceExcludes;
    @UriParam(label="consumer,mysql", defaultValue="latest")
    private String gtidNewChannelPosition = "latest";
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean tombstonesOnDelete;
    @UriParam(label="consumer,mysql", defaultValue="antlr")
    private String ddlParserMode = "antlr";

    @Override
    protected Configuration createConnectorConfiguration() {
        return this.createDebeziumMySqlConnectorConfiguration();
    }

    private Configuration createDebeziumMySqlConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.HOSTNAME, this.databaseHostName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.PORT, this.databasePort);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.USER, this.databaseUser);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.PASSWORD, this.databasePassword);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.SERVER_ID, this.databaseServerId);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.SERVER_NAME, this.databaseServerName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DATABASE_WHITELIST, this.databaseWhitelist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DATABASE_HISTORY, this.databaseHistory);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, FileDatabaseHistory.FILE_PATH, this.databaseHistoryFileName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, KafkaDatabaseHistory.TOPIC, this.databaseHistoryKafkaTopic);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, KafkaDatabaseHistory.BOOTSTRAP_SERVERS, this.databaseHistoryKafkaBootstrapServers);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DATABASE_WHITELIST, this.databaseWhitelist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DATABASE_BLACKLIST, this.databaseBlacklist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.TABLE_WHITELIST, this.tableWhitelist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.TABLE_BLACKLIST, this.tableBlacklist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.COLUMN_BLACKLIST, this.columnBlacklist);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.TIME_PRECISION_MODE, this.timePrecisionMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DECIMAL_HANDLING_MODE, this.decimalHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE, this.bigintUnsignedHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, this.includeSchemaChanges);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.INCLUDE_SQL_QUERY, this.includeQuery);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE, this.eventDeserializationFailureHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.INCONSISTENT_SCHEMA_HANDLING_MODE, this.inconsistentSchemaHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, CommonConnectorConfig.MAX_QUEUE_SIZE, this.maxQueueSize);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.MAX_BATCH_SIZE, this.maxBatchSize);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.POLL_INTERVAL_MS, this.pollIntervalMs);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.CONNECTION_TIMEOUT_MS, this.connectTimeoutMs);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.GTID_SOURCE_INCLUDES, this.gtidSourceIncludes);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.GTID_SOURCE_EXCLUDES, this.gtidSourceExcludes);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.GTID_NEW_CHANNEL_POSITION, this.gtidNewChannelPosition);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.TOMBSTONES_ON_DELETE, this.tombstonesOnDelete);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, MySqlConnectorConfig.DDL_PARSER_MODE, this.ddlParserMode);
        return configBuilder.build();
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        return this.validateMySqlConnectorConfiguration();
    }

    private ConfigurationValidation validateMySqlConnectorConfiguration() {
        if (MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databasePassword)) {
            return ConfigurationValidation.notValid("Required field 'databasePassword' must be set.");
        }
        if (MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databaseServerId)) {
            return ConfigurationValidation.notValid("Required field 'databaseServerId' must be set.");
        }
        if (MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databaseServerName)) {
            return ConfigurationValidation.notValid("Required field 'databaseServerName' must be set.");
        }
        if (this.databaseHistory.equals(DebeziumConstants.DEFAULT_DATABASE_HISTORY) && MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databaseHistoryFileName)) {
            return ConfigurationValidation.notValid(String.format("Required field 'databaseHistoryFileName' must be set since 'databaseHistory' is set to '%s'", DebeziumConstants.DEFAULT_DATABASE_HISTORY));
        }
        return ConfigurationValidation.valid();
    }

    @Override
    protected Class<?> configureConnectorClass() {
        return MySqlConnector.class;
    }

    public String getDatabaseHostName() {
        return this.databaseHostName;
    }

    public void setDatabaseHostName(String databaseHostName) {
        this.databaseHostName = databaseHostName;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public int getDatabaseServerId() {
        return this.databaseServerId;
    }

    public void setDatabaseServerId(int databaseServerId) {
        this.databaseServerId = databaseServerId;
    }

    public String getDatabaseHistoryKafkaTopic() {
        return this.databaseHistoryKafkaTopic;
    }

    public void setDatabaseHistoryKafkaTopic(String databaseHistoryKafkaTopic) {
        this.databaseHistoryKafkaTopic = databaseHistoryKafkaTopic;
    }

    public String getDatabaseWhitelist() {
        return this.databaseWhitelist;
    }

    public void setDatabaseWhitelist(String databaseWhitelist) {
        this.databaseWhitelist = databaseWhitelist;
    }

    public String getDatabaseHistory() {
        return this.databaseHistory;
    }

    public void setDatabaseHistory(String databaseHistory) {
        this.databaseHistory = databaseHistory;
    }

    public String getDatabaseHistoryFileName() {
        return this.databaseHistoryFileName;
    }

    public void setDatabaseHistoryFileName(String databaseHistoryFileName) {
        this.databaseHistoryFileName = databaseHistoryFileName;
    }

    public String getDatabaseHistoryKafkaBootstrapServers() {
        return this.databaseHistoryKafkaBootstrapServers;
    }

    public void setDatabaseHistoryKafkaBootstrapServers(String databaseHistoryKafkaBootstrapServers) {
        this.databaseHistoryKafkaBootstrapServers = databaseHistoryKafkaBootstrapServers;
    }

    public String getDatabaseBlacklist() {
        return this.databaseBlacklist;
    }

    public void setDatabaseBlacklist(String databaseBlacklist) {
        this.databaseBlacklist = databaseBlacklist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getColumnBlacklist() {
        return this.columnBlacklist;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getBigintUnsignedHandlingMode() {
        return this.bigintUnsignedHandlingMode;
    }

    public void setBigintUnsignedHandlingMode(String bigintUnsignedHandlingMode) {
        this.bigintUnsignedHandlingMode = bigintUnsignedHandlingMode;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeQuery() {
        return this.includeQuery;
    }

    public void setIncludeQuery(boolean includeQuery) {
        this.includeQuery = includeQuery;
    }

    public String getEventDeserializationFailureHandlingMode() {
        return this.eventDeserializationFailureHandlingMode;
    }

    public void setEventDeserializationFailureHandlingMode(String eventDeserializationFailureHandlingMode) {
        this.eventDeserializationFailureHandlingMode = eventDeserializationFailureHandlingMode;
    }

    public String getInconsistentSchemaHandlingMode() {
        return this.inconsistentSchemaHandlingMode;
    }

    public void setInconsistentSchemaHandlingMode(String inconsistentSchemaHandlingMode) {
        this.inconsistentSchemaHandlingMode = inconsistentSchemaHandlingMode;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(long connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public String getGtidSourceIncludes() {
        return this.gtidSourceIncludes;
    }

    public void setGtidSourceIncludes(String gtidSourceIncludes) {
        this.gtidSourceIncludes = gtidSourceIncludes;
    }

    public String getGtidSourceExcludes() {
        return this.gtidSourceExcludes;
    }

    public void setGtidSourceExcludes(String gtidSourceExcludes) {
        this.gtidSourceExcludes = gtidSourceExcludes;
    }

    public String getGtidNewChannelPosition() {
        return this.gtidNewChannelPosition;
    }

    public void setGtidNewChannelPosition(String gtidNewChannelPosition) {
        this.gtidNewChannelPosition = gtidNewChannelPosition;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public String getDdlParserMode() {
        return this.ddlParserMode;
    }

    public void setDdlParserMode(String ddlParserMode) {
        this.ddlParserMode = ddlParserMode;
    }
}

