/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConsumer;
import org.apache.camel.component.debezium.DebeziumTypeConverter;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.component.debezium.configuration.MySqlConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;

@UriEndpoint(firstVersion="3.0.0", scheme="debezium", title="Debezium", syntax="debezium:connectorType", label="database,sql,nosql", consumerOnly=true)
public class DebeziumEndpoint
extends DefaultEndpoint {
    @UriParam
    private EmbeddedDebeziumConfiguration configuration;
    @UriParam
    private MySqlConnectorEmbeddedDebeziumConfiguration mySqlConnectorEmbeddedDebeziumConfiguration;

    public DebeziumEndpoint(String uri, DebeziumComponent component, EmbeddedDebeziumConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public DebeziumEndpoint() {
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Cannot produce from a DebeziumEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DebeziumConsumer(this, processor);
    }

    public EmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }

    public MySqlConnectorEmbeddedDebeziumConfiguration getMySqlConnectorEmbeddedDebeziumConfiguration() {
        return this.mySqlConnectorEmbeddedDebeziumConfiguration;
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "DebeziumConsumer");
    }

    public Exchange createDbzExchange(SourceRecord record) {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        Schema valueSchema = record.valueSchema();
        Object value = record.value();
        Map<String, Object> sourceMetadata = this.extractSourceMetadataValueFromValueStruct(valueSchema, value);
        Object operation = this.extractValueFromValueStruct(valueSchema, value, "op");
        Object before = this.extractValueFromValueStruct(valueSchema, value, "before");
        Object after = this.extractAfterValueFromValueStruct(valueSchema, value);
        Object timestamp = this.extractValueFromValueStruct(valueSchema, value, "ts_ms");
        message.setHeader("CamelDebeziumIdentifier", (Object)record.topic());
        message.setHeader("CamelDebeziumKey", record.key());
        message.setHeader("CamelDebeziumSourceMetadata", sourceMetadata);
        message.setHeader("CamelDebeziumOperation", operation);
        message.setHeader("CamelDebeziumBefore", before);
        message.setHeader("CamelDebeziumTimestamp", timestamp);
        message.setBody(after);
        return exchange;
    }

    private Map<String, Object> extractSourceMetadataValueFromValueStruct(Schema schema, Object value) {
        Object valueExtracted = this.extractValueFromValueStruct(schema, value, "source");
        if (valueExtracted != null) {
            return DebeziumTypeConverter.toMap((Struct)valueExtracted);
        }
        return null;
    }

    private Object extractAfterValueFromValueStruct(Schema schema, Object value) {
        Object valueExtracted = this.extractValueFromValueStruct(schema, value, "after");
        if (valueExtracted == null && !this.isSchemaAStructSchema(schema)) {
            return value;
        }
        return valueExtracted;
    }

    private Object extractValueFromValueStruct(Schema schema, Object value, String fieldName) {
        if (this.isSchemaAStructSchema(schema) && value != null) {
            try {
                Struct valueStruct = (Struct)value;
                return valueStruct.get(fieldName);
            }
            catch (DataException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isSchemaAStructSchema(Schema schema) {
        return schema != null && schema.type().equals((Object)Schema.Type.STRUCT);
    }
}

