/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.debezium.DebeziumConnectorTypes;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.component.debezium.configuration.MySqlConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="debezium")
public class DebeziumComponent
extends DefaultComponent {
    private EmbeddedDebeziumConfiguration configuration;

    public DebeziumComponent() {
    }

    public DebeziumComponent(CamelContext context) {
        super(context);
    }

    protected DebeziumEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining) && this.configuration == null) {
            throw new IllegalArgumentException("Connector type must be configured on endpoint using syntax debezium:type");
        }
        if (this.configuration == null) {
            DebeziumConnectorTypes connectorTypes = DebeziumConnectorTypes.fromString(remaining);
            if (connectorTypes == DebeziumConnectorTypes.MYSQL) {
                this.configuration = new MySqlConnectorEmbeddedDebeziumConfiguration();
            } else {
                throw new IllegalArgumentException(String.format("Connector of type '%s' is not supported yet.", connectorTypes.getName().toLowerCase()));
            }
        }
        this.setProperties(this.configuration, parameters);
        ConfigurationValidation configurationValidation = this.configuration.validateConfiguration();
        if (!configurationValidation.isValid()) {
            throw new IllegalArgumentException(configurationValidation.getReason());
        }
        return new DebeziumEndpoint(uri, this, this.configuration);
    }

    public EmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EmbeddedDebeziumConfiguration configuration) {
        if (this.configuration == null) {
            this.configuration = configuration;
        }
    }
}

