/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CommitConsumer.class);
    private CommitService commitService;
    private List<String> commitHashes = new ArrayList<String>();

    public CommitConsumer(GitHubEndpoint endpoint, Processor processor, String branchName) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubCommitService");
        if (service != null) {
            LOG.debug("Using CommitService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.commitService = (CommitService)service;
        } else {
            this.commitService = new CommitService();
        }
        this.initService((GitHubService)this.commitService);
        LOG.info("GitHub CommitConsumer: Indexing current commits...");
        List commits = this.commitService.getCommits((IRepositoryIdProvider)this.getRepository(), branchName, null);
        for (RepositoryCommit commit : commits) {
            this.commitHashes.add(commit.getSha());
        }
    }

    @Override
    protected int poll() throws Exception {
        List commits = this.commitService.getCommits((IRepositoryIdProvider)this.getRepository());
        Stack<RepositoryCommit> newCommits = new Stack<RepositoryCommit>();
        for (RepositoryCommit commit : commits) {
            if (this.commitHashes.contains(commit.getSha())) continue;
            newCommits.push(commit);
            this.commitHashes.add(commit.getSha());
        }
        while (!newCommits.empty()) {
            RepositoryCommit newCommit = (RepositoryCommit)newCommits.pop();
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)newCommit);
            this.getProcessor().process(e);
        }
        return newCommits.size();
    }
}

