/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.catalog.LanguageValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.TimePatternConverter;
import org.apache.camel.catalog.URISupport;

public abstract class AbstractCamelCatalog {
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("([\\w.]+)");
    private static final Pattern SYNTAX_DASH_PATTERN = Pattern.compile("([\\w.-]+)");
    private static final Pattern COMPONENT_SYNTAX_PARSER = Pattern.compile("([^\\w-]*)([\\w-]+)");
    private SuggestionStrategy suggestionStrategy;
    private JSonSchemaResolver jsonSchemaResolver;

    public SuggestionStrategy getSuggestionStrategy() {
        return this.suggestionStrategy;
    }

    public void setSuggestionStrategy(SuggestionStrategy suggestionStrategy) {
        this.suggestionStrategy = suggestionStrategy;
    }

    public JSonSchemaResolver getJSonSchemaResolver() {
        return this.jsonSchemaResolver;
    }

    public void setJSonSchemaResolver(JSonSchemaResolver resolver) {
        this.jsonSchemaResolver = resolver;
    }

    public boolean validateTimePattern(String pattern) {
        return AbstractCamelCatalog.validateInteger(pattern);
    }

    public EndpointValidationResult validateEndpointProperties(String uri) {
        return this.validateEndpointProperties(uri, false, false, false);
    }

    public EndpointValidationResult validateEndpointProperties(String uri, boolean ignoreLenientProperties) {
        return this.validateEndpointProperties(uri, ignoreLenientProperties, false, false);
    }

    public EndpointValidationResult validateProperties(String scheme, Map<String, String> properties) {
        String string;
        List<Map<String, String>> dfRows;
        String dfName;
        EndpointValidationResult result = new EndpointValidationResult(scheme);
        String json = this.jsonSchemaResolver.getComponentJSonSchema(scheme);
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        List<Map<String, String>> componentProps = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        componentProps.stream().filter(c -> rows.stream().noneMatch(e -> Objects.equals(e.get("name"), c.get("name")))).forEach(rows::add);
        boolean lenient = Boolean.getBoolean(properties.getOrDefault("lenient", "false"));
        if ("dataformat".equals(scheme) && (dfName = properties.get("name")) != null && (dfRows = JSonSchemaHelper.parseJsonSchema("properties", string = this.jsonSchemaResolver.getDataFormatJSonSchema(dfName), true)) != null && !dfRows.isEmpty()) {
            rows.addAll(dfRows);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            boolean valid;
            boolean deprecated;
            boolean required;
            String value = entry.getValue();
            String originalName = entry.getKey();
            String name = entry.getKey();
            String propertyName = JSonSchemaHelper.getPropertyNameFromNameWithPrefix(rows, name = JSonSchemaHelper.stripOptionalPrefixFromName(rows, name));
            if (propertyName != null) {
                name = propertyName;
            }
            String prefix = JSonSchemaHelper.getPropertyPrefix(rows, name);
            String kind = JSonSchemaHelper.getPropertyKind(rows, name);
            boolean namePlaceholder = name.startsWith("{{") && name.endsWith("}}");
            boolean valuePlaceholder = value.startsWith("{{") || value.startsWith("${") || value.startsWith("$simple{");
            boolean lookup = value.startsWith("#") && value.length() > 1;
            boolean multiValue = prefix != null && originalName.startsWith(prefix) && JSonSchemaHelper.isPropertyMultiValue(rows, name);
            Map<String, String> row = JSonSchemaHelper.getRow(rows, name);
            if (row == null) {
                String[] suggestions;
                if (namePlaceholder || "stub".equals(scheme)) continue;
                if (lenient) {
                    result.addLenient(name);
                    continue;
                }
                result.addUnknown(name);
                if (this.suggestionStrategy == null || (suggestions = this.suggestionStrategy.suggestEndpointOptions(JSonSchemaHelper.getNames(rows), name)) == null) continue;
                result.addUnknownSuggestions(name, suggestions);
                continue;
            }
            String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, name);
            if (defaultValue != null) {
                result.addDefaultValue(name, defaultValue);
            }
            if ((required = JSonSchemaHelper.isPropertyRequired(rows, name)) && URISupport.isEmpty(value)) {
                result.addRequired(name);
            }
            if (deprecated = JSonSchemaHelper.isPropertyDeprecated(rows, name)) {
                result.addDeprecated(name);
            }
            String enums = JSonSchemaHelper.getPropertyEnum(rows, name);
            if (!(multiValue || valuePlaceholder || lookup || enums == null)) {
                String[] choices = enums.split(",");
                boolean found = false;
                for (String s : choices) {
                    if (!value.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result.addInvalidEnum(name, value);
                    result.addInvalidEnumChoices(name, choices);
                    if (this.suggestionStrategy != null) {
                        LinkedHashSet<String> names = new LinkedHashSet<String>();
                        names.addAll(Arrays.asList(choices));
                        String[] suggestions = this.suggestionStrategy.suggestEndpointOptions(names, value);
                        if (suggestions != null) {
                            result.addInvalidEnumSuggestions(name, suggestions);
                        }
                    }
                }
            }
            if (!(multiValue || enums != null || "path".equals(kind) || !JSonSchemaHelper.isPropertyObject(rows, name) || value.startsWith("#") && value.length() > 1)) {
                result.addInvalidReference(name, value);
            }
            if (!multiValue && !valuePlaceholder && !lookup && JSonSchemaHelper.isPropertyBoolean(rows, name)) {
                boolean bool;
                boolean bl = bool = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
                if (!bool) {
                    result.addInvalidBoolean(name, value);
                }
            }
            if (!(multiValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyInteger(rows, name) || (valid = AbstractCamelCatalog.validateInteger(value)))) {
                result.addInvalidInteger(name, value);
            }
            if (multiValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyNumber(rows, name)) continue;
            valid = false;
            try {
                valid = !Double.valueOf(value).isNaN() || !Float.valueOf(value).isNaN();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (valid) continue;
            result.addInvalidNumber(name, value);
        }
        for (Map map : rows) {
            String name = (String)map.get("name");
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, name);
            if (!required) continue;
            String value = properties.get(name);
            if (URISupport.isEmpty(value)) {
                value = JSonSchemaHelper.getPropertyDefaultValue(rows, name);
            }
            if (!URISupport.isEmpty(value)) continue;
            result.addRequired(name);
        }
        return result;
    }

    public EndpointValidationResult validateEndpointProperties(String uri, boolean ignoreLenientProperties, boolean consumerOnly, boolean producerOnly) {
        String string;
        List<Map<String, String>> dfRows;
        String dfName;
        Map<String, String> properties;
        boolean lenientProperties;
        List<Map<String, String>> rows;
        String scheme;
        EndpointValidationResult result = new EndpointValidationResult(uri);
        try {
            String json = null;
            URI uRI = URISupport.normalizeUri(uri);
            scheme = uRI.getScheme();
            if (scheme != null) {
                json = this.jsonSchemaResolver.getComponentJSonSchema(scheme);
            }
            if (json == null) {
                if (uri.startsWith("{{")) {
                    result.addIncapable(uri);
                } else if (scheme != null) {
                    result.addUnknownComponent(scheme);
                } else {
                    result.addUnknownComponent(uri);
                }
                return result;
            }
            rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            boolean canConsumeAndProduce = false;
            if (!JSonSchemaHelper.isComponentConsumerOnly(rows) && !JSonSchemaHelper.isComponentProducerOnly(rows)) {
                canConsumeAndProduce = true;
            }
            lenientProperties = canConsumeAndProduce && consumerOnly ? false : !ignoreLenientProperties && JSonSchemaHelper.isComponentLenientProperties(rows);
            rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
            properties = this.endpointProperties(uri);
        }
        catch (URISyntaxException e) {
            if (uri.startsWith("{{")) {
                result.addIncapable(uri);
            } else {
                result.addSyntaxError(e.getMessage());
            }
            return result;
        }
        if ("dataformat".equals(scheme) && (dfName = properties.get("name")) != null && (dfRows = JSonSchemaHelper.parseJsonSchema("properties", string = this.jsonSchemaResolver.getDataFormatJSonSchema(dfName), true)) != null && !dfRows.isEmpty()) {
            rows.addAll(dfRows);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            boolean valid;
            boolean deprecated;
            boolean required;
            String defaultValue;
            String value = entry.getValue();
            String originalName = entry.getKey();
            String name = entry.getKey();
            String propertyName = JSonSchemaHelper.getPropertyNameFromNameWithPrefix(rows, name = JSonSchemaHelper.stripOptionalPrefixFromName(rows, name));
            if (propertyName != null) {
                name = propertyName;
            }
            String prefix = JSonSchemaHelper.getPropertyPrefix(rows, name);
            String kind = JSonSchemaHelper.getPropertyKind(rows, name);
            boolean namePlaceholder = name.startsWith("{{") && name.endsWith("}}");
            boolean valuePlaceholder = value.startsWith("{{") || value.startsWith("${") || value.startsWith("$simple{");
            boolean lookup = value.startsWith("#") && value.length() > 1;
            boolean mulitValue = prefix != null && originalName.startsWith(prefix) && JSonSchemaHelper.isPropertyMultiValue(rows, name);
            Map<String, String> row = JSonSchemaHelper.getRow(rows, name);
            if (row == null) {
                String[] suggestions;
                if (namePlaceholder || "stub".equals(scheme)) continue;
                if (lenientProperties) {
                    result.addLenient(name);
                    continue;
                }
                result.addUnknown(name);
                if (this.suggestionStrategy == null || (suggestions = this.suggestionStrategy.suggestEndpointOptions(JSonSchemaHelper.getNames(rows), name)) == null) continue;
                result.addUnknownSuggestions(name, suggestions);
                continue;
            }
            if ("parameter".equals(kind)) {
                boolean consumer;
                if (consumerOnly) {
                    boolean producer = JSonSchemaHelper.isPropertyProducerOnly(rows, name);
                    if (producer) {
                        result.addNotConsumerOnly(name);
                    }
                } else if (producerOnly && (consumer = JSonSchemaHelper.isPropertyConsumerOnly(rows, name))) {
                    result.addNotProducerOnly(name);
                }
            }
            if ((defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, name)) != null) {
                result.addDefaultValue(name, defaultValue);
            }
            if ((required = JSonSchemaHelper.isPropertyRequired(rows, name)) && URISupport.isEmpty(value)) {
                result.addRequired(name);
            }
            if (deprecated = JSonSchemaHelper.isPropertyDeprecated(rows, name)) {
                result.addDeprecated(name);
            }
            String enums = JSonSchemaHelper.getPropertyEnum(rows, name);
            if (!(mulitValue || valuePlaceholder || lookup || enums == null)) {
                String[] choices = enums.split(",");
                boolean found = false;
                for (String s : choices) {
                    if (!value.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result.addInvalidEnum(name, value);
                    result.addInvalidEnumChoices(name, choices);
                    if (this.suggestionStrategy != null) {
                        LinkedHashSet<String> names = new LinkedHashSet<String>();
                        names.addAll(Arrays.asList(choices));
                        String[] suggestions = this.suggestionStrategy.suggestEndpointOptions(names, value);
                        if (suggestions != null) {
                            result.addInvalidEnumSuggestions(name, suggestions);
                        }
                    }
                }
            }
            if (!(mulitValue || enums != null || "path".equals(kind) || !JSonSchemaHelper.isPropertyObject(rows, name) || value.startsWith("#") && value.length() > 1)) {
                result.addInvalidReference(name, value);
            }
            if (!mulitValue && !valuePlaceholder && !lookup && JSonSchemaHelper.isPropertyBoolean(rows, name)) {
                boolean bool;
                boolean bl = bool = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
                if (!bool) {
                    result.addInvalidBoolean(name, value);
                }
            }
            if (!(mulitValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyInteger(rows, name) || (valid = AbstractCamelCatalog.validateInteger(value)))) {
                result.addInvalidInteger(name, value);
            }
            if (mulitValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyNumber(rows, name)) continue;
            valid = false;
            try {
                valid = !Double.valueOf(value).isNaN() || !Float.valueOf(value).isNaN();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (valid) continue;
            result.addInvalidNumber(name, value);
        }
        for (Map map : rows) {
            String name = (String)map.get("name");
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, name);
            if (!required) continue;
            String value = properties.get(name);
            if (URISupport.isEmpty(value)) {
                value = JSonSchemaHelper.getPropertyDefaultValue(rows, name);
            }
            if (!URISupport.isEmpty(value)) continue;
            result.addRequired(name);
        }
        return result;
    }

    public Map<String, String> endpointProperties(String uri) throws URISyntaxException {
        String value;
        int idx;
        URI u = URISupport.normalizeUri(uri);
        String scheme = u.getScheme();
        String json = this.jsonSchemaResolver.getComponentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        String alternativeSyntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (row.containsKey("syntax")) {
                syntax = row.get("syntax");
            }
            if (!row.containsKey("alternativeSyntax")) continue;
            alternativeSyntax = row.get("alternativeSyntax");
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        LinkedHashMap<String, String> userInfoOptions = new LinkedHashMap<String, String>();
        if (alternativeSyntax != null && alternativeSyntax.contains("@")) {
            alternativeSyntax = CatalogHelper.after(alternativeSyntax, ":");
            int idx2 = alternativeSyntax.indexOf("@");
            String fields = alternativeSyntax.substring(0, idx2);
            String[] names = fields.split(":");
            String authority = u.getAuthority();
            if (authority != null && authority.contains("@")) {
                String username = null;
                String password = null;
                String userInfo = authority.substring(0, authority.indexOf("@"));
                String[] parts = userInfo.split(":");
                if (parts.length == 2) {
                    username = parts[0];
                    password = parts[1];
                } else {
                    username = userInfo;
                }
                if (names.length == 2) {
                    userInfoOptions.put(names[0], username);
                    if (password != null) {
                        userInfoOptions.put(names[1], password);
                    }
                }
            }
        }
        syntax = CatalogHelper.after(syntax, ":");
        uri = CatalogHelper.after(uri, ":");
        String uriPath = URISupport.stripQuery(uri);
        if (!userInfoOptions.isEmpty() && (idx = uriPath.indexOf(64)) > -1) {
            uriPath = uriPath.substring(idx + 1);
        }
        if (uriPath != null && uriPath.startsWith("//")) {
            uriPath = uriPath.substring(2);
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (scheme.equals(s)) continue;
            word.add(s);
        }
        String[] tokens = SYNTAX_PATTERN.split(syntax);
        ArrayList<String> word2 = new ArrayList<String>();
        int prev = 0;
        int prevPath = 0;
        if (("activemq".equals(scheme) || "jms".equals(scheme)) && uriPath.startsWith("temp:")) {
            prevPath = 5;
        }
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            int idx3 = -1;
            int len = 0;
            if (":".equals(token)) {
                idx3 = uriPath.indexOf("://", prevPath);
                len = 3;
            }
            if (idx3 == -1) {
                idx3 = uriPath.indexOf(token, prevPath);
                len = token.length();
            }
            if (idx3 <= 0) continue;
            String option = uriPath.substring(prev, idx3);
            word2.add(option);
            prevPath = prev = idx3 + len;
        }
        if (prev > 0 || word2.isEmpty()) {
            String option = uriPath.substring(prev);
            word2.add(option);
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        boolean defaultValueAdded = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (!userInfoOptions.isEmpty()) {
            options.putAll(userInfoOptions);
        }
        Iterator it = word2.iterator();
        for (int i = 0; i < word.size(); ++i) {
            String value2;
            String key = (String)word.get(i);
            boolean allOptions = word.size() == word2.size();
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
            String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
            if (allOptions) {
                value2 = (String)it.next();
                options.put(key, value2);
                continue;
            }
            if (!required) {
                boolean last;
                value2 = null;
                boolean bl = last = i == word.size() - 1;
                if (last) {
                    String string = value2 = it.hasNext() ? (String)it.next() : null;
                    if (value2 != null) {
                        options.put(key, value2);
                    } else {
                        value2 = defaultValue;
                    }
                }
                if (value2 == null) continue;
                options.put(key, value2);
                defaultValueAdded = true;
                continue;
            }
            String string = value2 = it.hasNext() ? (String)it.next() : null;
            if (value2 == null) continue;
            options.put(key, value2);
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (defaultValueAdded) {
                boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
                String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
                if (!required && defaultValue != null && defaultValue.equals(value)) continue;
            }
            answer.put(key, value);
        }
        Map<String, Object> parameters = URISupport.parseParameters(u);
        while (!parameters.isEmpty()) {
            Map<String, Object> values;
            String csb;
            String prefix;
            Map.Entry<String, Object> entry = parameters.entrySet().iterator().next();
            String key = entry.getKey();
            value = entry.getValue() != null ? entry.getValue().toString() : "";
            boolean multiValued = JSonSchemaHelper.isPropertyMultiValue(rows, key);
            if (multiValued && (prefix = JSonSchemaHelper.getPropertyPrefix(rows, key)) != null && !(csb = (values = URISupport.extractProperties(parameters, prefix)).entrySet().stream().map(multi -> prefix + (String)multi.getKey() + "=" + (multi.getValue() != null ? multi.getValue().toString() : "")).collect(Collectors.joining("&"))).isEmpty()) {
                value = value + "&" + csb;
            }
            answer.put(key, value);
            parameters.remove(key);
        }
        return answer;
    }

    public Map<String, String> endpointLenientProperties(String uri) throws URISyntaxException {
        URI u = URISupport.normalizeUri(uri);
        String scheme = u.getScheme();
        String json = this.jsonSchemaResolver.getComponentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        Map<String, Object> parameters = URISupport.parseParameters(u);
        Set<String> names = JSonSchemaHelper.getNames(rows);
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        parameters.forEach((k, v) -> {
            String key = k;
            String value = v != null ? v.toString() : "";
            int dot = key.indexOf(46);
            if (dot != -1) {
                String prefix = key.substring(0, dot + 1);
                String option = JSonSchemaHelper.getPropertyNameFromNameWithPrefix(rows, prefix);
                if (option == null || !JSonSchemaHelper.isPropertyMultiValue(rows, option)) {
                    answer.put(key, value);
                }
            } else if (!names.contains(key)) {
                answer.put(key, value);
            }
        });
        return answer;
    }

    public String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(":")) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }

    private String doAsEndpointUri(String scheme, String json, String ampersand, boolean encode) throws URISyntaxException {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map<String, String> row : rows) {
            String name = row.get("name");
            String required = row.get("required");
            String value = row.get("value");
            String defaultValue = row.get("defaultValue");
            String valueToAdd = null;
            if ("true".equals(required)) {
                String string = valueToAdd = value != null ? value : defaultValue;
                if (valueToAdd == null) {
                    valueToAdd = "";
                }
            } else {
                if (value != null && defaultValue == null) {
                    valueToAdd = value;
                }
                if (value != null && defaultValue != null && !value.equals(defaultValue)) {
                    valueToAdd = value;
                }
            }
            if (valueToAdd == null) continue;
            copy.put(name, valueToAdd);
        }
        return this.doAsEndpointUri(scheme, copy, ampersand, encode);
    }

    public String asEndpointUri(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&", encode);
    }

    public String asEndpointUriXml(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&amp;", encode);
    }

    String doAsEndpointUri(String scheme, Map<String, String> properties, String ampersand, boolean encode) throws URISyntaxException {
        String remainder;
        boolean queryOnly;
        String json = this.jsonSchemaResolver.getComponentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String originalSyntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (!row.containsKey("syntax")) continue;
            originalSyntax = row.get("syntax");
            break;
        }
        if (originalSyntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        properties = this.filterProperties(scheme, properties);
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        String syntax = "";
        if (originalSyntax.contains(":")) {
            originalSyntax = CatalogHelper.after(originalSyntax, ":");
        }
        TreeMap<String, String> copy = new TreeMap<String, String>(properties);
        Matcher syntaxMatcher = COMPONENT_SYNTAX_PARSER.matcher(originalSyntax);
        while (syntaxMatcher.find()) {
            syntax = syntax + syntaxMatcher.group(1);
            String propertyName = syntaxMatcher.group(2);
            String propertyValue = (String)copy.remove(propertyName);
            syntax = syntax + (propertyValue != null ? propertyValue : propertyName);
        }
        String[] keys = AbstractCamelCatalog.syntaxKeys(originalSyntax);
        boolean hasAllKeys = properties.keySet().containsAll(Arrays.asList(keys));
        StringBuilder sb = new StringBuilder();
        if (hasAllKeys) {
            sb.append(syntax);
            if (!copy.isEmpty()) {
                boolean hasQuestionmark = sb.toString().contains("?");
                sb.append(hasQuestionmark ? ampersand : Character.valueOf('?'));
                String query = URISupport.createQueryString(copy, ampersand, encode);
                sb.append(query);
            }
        } else {
            String[] tokens = SYNTAX_DASH_PATTERN.split(syntax);
            Matcher matcher = SYNTAX_PATTERN.matcher(originalSyntax);
            ArrayList<String> options = new ArrayList<String>();
            while (matcher.find()) {
                String s = matcher.group(1);
                options.add(s);
            }
            syntax = syntax.replaceAll("\\{\\{", "BEGINCAMELPLACEHOLDER");
            syntax = syntax.replaceAll("\\}\\}", "ENDCAMELPLACEHOLDER");
            Matcher matcher2 = SYNTAX_DASH_PATTERN.matcher(syntax);
            ArrayList<String> options2 = new ArrayList<String>();
            while (matcher2.find()) {
                String s = matcher2.group(1);
                s = s.replaceAll("BEGINCAMELPLACEHOLDER", "\\{\\{");
                s = s.replaceAll("ENDCAMELPLACEHOLDER", "\\}\\}");
                options2.add(s);
            }
            int range = 0;
            boolean first = true;
            boolean hasQuestionmark = false;
            for (int i = 0; i < options.size(); ++i) {
                String value;
                boolean contains;
                String key = (String)options.get(i);
                String key2 = (String)options2.get(i);
                String token = null;
                if (tokens.length > i) {
                    token = tokens[i];
                }
                if (!(contains = properties.containsKey(key)) && JSonSchemaHelper.isPropertyRequired(rows, key) && (value = JSonSchemaHelper.getPropertyDefaultValue(rows, key)) != null) {
                    properties.put(key, value);
                    key2 = value;
                }
                if (properties.containsKey(key)) {
                    if (!first && token != null) {
                        sb.append(token);
                    }
                    hasQuestionmark |= key.contains("?") || token != null && token.contains("?");
                    sb.append(key2);
                    first = false;
                }
                ++range;
            }
            while (range < options2.size()) {
                String token = null;
                if (tokens.length > range) {
                    token = tokens[range];
                }
                String key2 = (String)options2.get(range);
                sb.append(token);
                sb.append(key2);
                hasQuestionmark |= key2.contains("?") || token != null && token.contains("?");
                ++range;
            }
            if (!copy.isEmpty()) {
                sb.append(hasQuestionmark ? ampersand : Character.valueOf('?'));
                String query = URISupport.createQueryString(copy, ampersand, encode);
                sb.append(query);
            }
        }
        if (queryOnly = (remainder = sb.toString()).startsWith("?")) {
            return scheme + remainder;
        }
        if (!remainder.isEmpty()) {
            return scheme + ":" + remainder;
        }
        return scheme;
    }

    private static String[] syntaxKeys(String syntax) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (syntax != null) {
            String current = "";
            for (int i = 0; i < syntax.length(); ++i) {
                char ch = syntax.charAt(i);
                if (Character.isLetterOrDigit(ch)) {
                    current = current + ch;
                    continue;
                }
                if (current.length() <= 0) continue;
                tokens.add(current);
                current = "";
            }
            if (current.length() > 0) {
                tokens.add(current);
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private LanguageValidationResult doValidateSimple(ClassLoader classLoader, String simple, boolean predicate) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String resolved = simple.replaceAll("\\{\\{(.+)\\}\\}", "~^$1^~");
        LanguageValidationResult answer = new LanguageValidationResult(simple);
        Object instance = null;
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass("org.apache.camel.language.simple.SimpleLanguage");
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && instance != null) {
            Throwable cause = null;
            try {
                if (predicate) {
                    instance.getClass().getMethod("createPredicate", String.class).invoke(instance, resolved);
                } else {
                    instance.getClass().getMethod("createExpression", String.class).invoke(instance, resolved);
                }
            }
            catch (InvocationTargetException e) {
                cause = e.getTargetException();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                Object result;
                Method method2;
                String errMsg = cause.getMessage();
                errMsg = errMsg.replaceAll("\\~\\^(.+)\\^\\~", "{{$1}}");
                answer.setError(errMsg);
                if (cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleIllegalSyntaxException") || cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleParserException")) {
                    try {
                        method2 = cause.getClass().getMethod("getIndex", new Class[0]);
                        result = method2.invoke((Object)cause, new Object[0]);
                        if (result != null) {
                            int index = (Integer)result;
                            answer.setIndex(index);
                        }
                    }
                    catch (Throwable method2) {
                        // empty catch block
                    }
                }
                if (cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleIllegalSyntaxException")) {
                    String msg;
                    int idx;
                    try {
                        method2 = cause.getClass().getMethod("getShortMessage", new Class[0]);
                        result = method2.invoke((Object)cause, new Object[0]);
                        if (result != null) {
                            String msg2 = (String)result;
                            answer.setShortError(msg2);
                        }
                    }
                    catch (Throwable method3) {
                        // empty catch block
                    }
                    if (answer.getShortError() == null && (idx = (msg = answer.getError()).indexOf(" at location ")) > 0) {
                        msg = msg.substring(0, idx);
                        answer.setShortError(msg);
                    }
                }
            }
        }
        return answer;
    }

    public LanguageValidationResult validateLanguagePredicate(ClassLoader classLoader, String language, String text) {
        if ("simple".equals(language)) {
            return this.doValidateSimple(classLoader, text, true);
        }
        return this.doValidateLanguage(classLoader, language, text, true);
    }

    public LanguageValidationResult validateLanguageExpression(ClassLoader classLoader, String language, String text) {
        if ("simple".equals(language)) {
            return this.doValidateSimple(classLoader, text, false);
        }
        return this.doValidateLanguage(classLoader, language, text, false);
    }

    private LanguageValidationResult doValidateLanguage(ClassLoader classLoader, String language, String text, boolean predicate) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        LanguageValidationResult answer = new LanguageValidationResult(text);
        String json = this.jsonSchemaResolver.getLanguageJSonSchema(language);
        if (json == null) {
            answer.setError("Unknown language " + language);
            return answer;
        }
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        String className = null;
        for (Map<String, String> row : rows) {
            if (!row.containsKey("javaType")) continue;
            className = row.get("javaType");
        }
        if (className == null) {
            answer.setError("Cannot find javaType for language " + language);
            return answer;
        }
        Object instance = null;
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(className);
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && instance != null) {
            Throwable cause = null;
            try {
                if (predicate) {
                    instance.getClass().getMethod("createPredicate", String.class).invoke(instance, text);
                } else {
                    instance.getClass().getMethod("createExpression", String.class).invoke(instance, text);
                }
            }
            catch (InvocationTargetException e) {
                cause = e.getTargetException();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                answer.setError(cause.getMessage());
            }
        }
        return answer;
    }

    private Map<String, String> filterProperties(String scheme, Map<String, String> options) {
        String showAll;
        if ("log".equals(scheme) && "true".equals(showAll = options.get("showAll"))) {
            LinkedHashMap<String, String> filtered = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                boolean skip = key.startsWith("show") && !key.equals("showAll");
                if (skip) continue;
                filtered.put(key, entry.getValue());
            }
            return filtered;
        }
        return options;
    }

    private static boolean validateInteger(String value) {
        boolean valid = false;
        try {
            valid = Integer.valueOf(value) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!valid) {
            try {
                TimePatternConverter.toMilliSeconds(value);
                valid = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }
}

