/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.CamelUndertowHttpHandler;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowConstants;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class UndertowConsumer
extends DefaultConsumer
implements HttpHandler {
    private CamelWebSocketHandler webSocketHandler;

    public UndertowConsumer(UndertowEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public UndertowEndpoint getEndpoint() {
        return (UndertowEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        UndertowEndpoint endpoint = this.getEndpoint();
        if (endpoint.isWebSocket()) {
            this.webSocketHandler = (CamelWebSocketHandler)endpoint.getComponent().registerEndpoint(endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext(), new CamelWebSocketHandler());
            this.webSocketHandler.setConsumer(this);
        } else {
            EagerFormParsingHandler httpHandler = new EagerFormParsingHandler().setNext((HttpHandler)this);
            if (endpoint.getAccessLog().booleanValue()) {
                Object accessLogReciever = null;
                accessLogReciever = endpoint.getAccessLogReceiver() != null ? endpoint.getAccessLogReceiver() : new JBossLoggingAccessLogReceiver();
                httpHandler = new AccessLogHandler((HttpHandler)httpHandler, accessLogReciever, "common", AccessLogHandler.class.getClassLoader());
            }
            if (endpoint.getHandlers() != null) {
                httpHandler = this.wrapHandler((HttpHandler)httpHandler, endpoint);
            }
            endpoint.getComponent().registerEndpoint(endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext(), (HttpHandler)Handlers.httpContinueRead((HttpHandler)httpHandler));
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.webSocketHandler != null) {
            this.webSocketHandler.setConsumer(null);
        }
        UndertowEndpoint endpoint = this.getEndpoint();
        endpoint.getComponent().unregisterEndpoint(endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        HttpString requestMethod = httpExchange.getRequestMethod();
        if (Methods.OPTIONS.equals(requestMethod) && !this.getEndpoint().isOptionsEnabled()) {
            CollectionStringBuffer csb = new CollectionStringBuffer(",");
            Set<HttpHandlerRegistrationInfo> handlers = this.getEndpoint().getComponent().getHandlers();
            for (HttpHandlerRegistrationInfo reg : handlers) {
                URI uri = reg.getUri();
                if (reg.getMethodRestrict() == null || !this.getEndpoint().getHttpURI().equals(uri)) continue;
                String restrict = reg.getMethodRestrict();
                if (restrict.endsWith(",OPTIONS")) {
                    restrict = restrict.substring(0, restrict.length() - 8);
                }
                csb.append((Object)restrict);
            }
            String allowedMethods = csb.toString();
            if (ObjectHelper.isEmpty((Object)allowedMethods)) {
                allowedMethods = this.getEndpoint().getHttpMethodRestrict();
            }
            if (ObjectHelper.isEmpty((Object)allowedMethods)) {
                allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            }
            if (!allowedMethods.contains("OPTIONS")) {
                allowedMethods = allowedMethods + ",OPTIONS";
            }
            httpExchange.setStatusCode(200);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseHeaders().put(Headers.ALLOW, allowedMethods);
            httpExchange.endExchange();
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        Exchange camelExchange = this.getEndpoint().createExchange(httpExchange);
        this.createUoW(camelExchange);
        try {
            this.getProcessor().process(camelExchange);
            this.sendResponse(httpExchange, camelExchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
        finally {
            this.doneUoW(camelExchange);
        }
    }

    private void sendResponse(HttpServerExchange httpExchange, Exchange camelExchange) throws IOException, NoTypeConversionAvailableException {
        block26: {
            Object body = this.getResponseBody(httpExchange, camelExchange);
            if (body == null) {
                this.log.trace("No payload to send as reply for exchange: {}", (Object)camelExchange);
                httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
                httpExchange.getResponseSender().send("No response available");
                return;
            }
            if (this.getEndpoint().isUseStreaming() && body instanceof InputStream) {
                httpExchange.startBlocking();
                try (InputStream input = (InputStream)body;
                     OutputStream output = httpExchange.getOutputStream();){
                    IOHelper.copy((InputStream)input, (OutputStream)output, (int)4096, (boolean)true);
                    break block26;
                }
            }
            TypeConverter tc = this.getEndpoint().getCamelContext().getTypeConverter();
            ByteBuffer bodyAsByteBuffer = (ByteBuffer)tc.mandatoryConvertTo(ByteBuffer.class, body);
            httpExchange.getResponseSender().send(bodyAsByteBuffer);
        }
    }

    public void sendMessage(String connectionKey, WebSocketChannel channel, Object message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        if (channel != null) {
            exchange.getIn().setHeader("websocket.channel", (Object)channel);
        }
        exchange.getIn().setBody(message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    UndertowConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    public void sendEventNotification(String connectionKey, WebSocketHttpExchange transportExchange, WebSocketChannel channel, UndertowConstants.EventType eventType) {
        final Exchange exchange = this.getEndpoint().createExchange();
        Message in = exchange.getIn();
        in.setHeader("websocket.connectionKey", (Object)connectionKey);
        in.setHeader("websocket.eventType", (Object)eventType.getCode());
        in.setHeader("websocket.eventTypeEnum", (Object)eventType);
        if (channel != null) {
            in.setHeader("websocket.channel", (Object)channel);
        }
        if (transportExchange != null) {
            in.setHeader("websocket.exchange", (Object)transportExchange);
        }
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    UndertowConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    private Object getResponseBody(HttpServerExchange httpExchange, Exchange camelExchange) throws IOException {
        Object result = camelExchange.hasOut() ? this.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getOut()) : this.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getIn());
        return result;
    }

    private HttpHandler wrapHandler(HttpHandler handler, UndertowEndpoint endpoint) {
        String[] handlders;
        HttpHandler nextHandler = handler;
        for (String obj : handlders = endpoint.getHandlers().split(",")) {
            if (EndpointHelper.isReferenceParameter((String)obj)) {
                obj = obj.substring(1);
            }
            CamelUndertowHttpHandler h = (CamelUndertowHttpHandler)CamelContextHelper.mandatoryLookup((CamelContext)endpoint.getCamelContext(), (String)obj, CamelUndertowHttpHandler.class);
            h.setNext(nextHandler);
            nextHandler = h;
        }
        return nextHandler;
    }
}

