/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;

public class ChoiceProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware {
    private String id;
    private final List<FilterProcessor> filters;
    private final Processor otherwise;
    private transient long notFiltered;

    public ChoiceProcessor(List<FilterProcessor> filters, Processor otherwise) {
        this.filters = filters;
        this.otherwise = otherwise;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Iterator<Processor> processors = this.next().iterator();
        final Object existing = exchange.getProperty("CamelFilterMatched");
        AsyncCallback choiceCallback = new AsyncCallback(){

            public void done(boolean doneSync) {
                if (existing != null) {
                    exchange.setProperty("CamelFilterMatched", existing);
                } else {
                    exchange.removeProperty("CamelFilterMatched");
                }
                callback.done(doneSync);
            }
        };
        while (processors.hasNext()) {
            Processor processor = processors.next();
            boolean matches = false;
            if (processor instanceof FilterProcessor) {
                FilterProcessor filter = (FilterProcessor)processor;
                try {
                    matches = filter.matches(exchange);
                    processor = filter.getProcessor();
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
            } else {
                ++this.notFiltered;
                matches = true;
            }
            if (!PipelineHelper.continueProcessing(exchange, "so breaking out of choice", this.log)) break;
            if (!matches) continue;
            AsyncProcessor async = AsyncProcessorConverterHelper.convert((Processor)processor);
            return async.process(exchange, choiceCallback);
        }
        choiceCallback.done(true);
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("choice{");
        boolean first = true;
        for (Processor processor : this.filters) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("when ");
            builder.append(processor);
        }
        if (this.otherwise != null) {
            builder.append(", otherwise: ");
            builder.append(this.otherwise);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getTraceLabel() {
        return "choice";
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    public long getNotFilteredCount() {
        return this.notFiltered;
    }

    public void reset() {
        for (FilterProcessor filter : this.getFilters()) {
            filter.reset();
        }
        this.notFiltered = 0L;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.filters != null) {
            answer.addAll(this.filters);
        }
        if (this.otherwise != null) {
            answer.add(this.otherwise);
        }
        return answer;
    }

    public boolean hasNext() {
        return this.otherwise != null || this.filters != null && !this.filters.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.filters, this.otherwise});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.otherwise, this.filters});
    }
}

