/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;

public class CatchProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private String id;
    private final List<Class<? extends Throwable>> exceptions;
    private final Predicate onWhen;

    public CatchProcessor(List<Class<? extends Throwable>> exceptions, Processor processor, Predicate onWhen, Predicate handled) {
        super(processor);
        this.exceptions = exceptions;
        this.onWhen = onWhen;
    }

    public String toString() {
        return "Catch[" + this.exceptions + " -> " + this.getProcessor() + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        return "catch";
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Exception e = exchange.getException();
        Throwable caught = this.catches(exchange, e);
        if (exchange.getProperty("CamelExceptionHandled") != null || caught == null) {
            callback.done(true);
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("This CatchProcessor catches the exception: {} caused by: {}", (Object)caught.getClass().getName(), (Object)e.getMessage());
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        exchange.setProperty("CamelExceptionHandled", (Object)true);
        exchange.setProperty("CamelExceptionCaught", (Object)e);
        exchange.setException(null);
        exchange.removeProperty("CamelRedeliveryExhausted");
        if (this.log.isDebugEnabled()) {
            this.log.debug("The exception is handled for the exception: {} caused by: {}", new Object[]{e.getClass().getName(), e.getMessage()});
        }
        EventHelper.notifyExchangeFailureHandling((CamelContext)exchange.getContext(), (Exchange)exchange, (Processor)this.processor, (boolean)false, null);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                EventHelper.notifyExchangeFailureHandled((CamelContext)exchange.getContext(), (Exchange)exchange, (Processor)CatchProcessor.this.processor, (boolean)false, null);
                exchange.removeProperty("CamelRedeliveryExhausted");
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn((Exchange)exchange);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    protected Throwable catches(Exchange exchange, Throwable exception) {
        for (Throwable e : ObjectHelper.createExceptionIterable((Throwable)exception)) {
            for (Class<? extends Throwable> type : this.exceptions) {
                if (!type.isInstance(e) || !this.matchesWhen(exchange)) continue;
                return e;
            }
        }
        return null;
    }

    public List<Class<? extends Throwable>> getExceptions() {
        return this.exceptions;
    }

    protected boolean matchesWhen(Exchange exchange) {
        if (this.onWhen == null) {
            return true;
        }
        return this.onWhen.matches(exchange);
    }
}

