/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.OrderedProperties;

public abstract class AbstractLocationPropertiesSource
extends ServiceSupport
implements LoadablePropertiesSource,
LocationPropertiesSource {
    private final Properties properties = new OrderedProperties();
    private final PropertiesComponent propertiesComponent;
    private final PropertiesLocation location;

    protected AbstractLocationPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        this.propertiesComponent = propertiesComponent;
        this.location = location;
    }

    abstract Properties loadPropertiesFromLocation(PropertiesComponent var1, PropertiesLocation var2);

    @Override
    public PropertiesLocation getLocation() {
        return this.location;
    }

    public Properties loadProperties() {
        return this.properties;
    }

    public Properties loadProperties(Predicate<String> filter) {
        Properties answer = new Properties();
        for (String name : answer.stringPropertyNames()) {
            if (!filter.test(name)) continue;
            answer.put(name, this.properties.get(name));
        }
        return answer;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    protected void doInit() throws Exception {
        super.doInit();
        Properties prop = this.loadPropertiesFromLocation(this.propertiesComponent, this.location);
        if (prop != null) {
            prop = AbstractLocationPropertiesSource.prepareLoadedProperties(prop);
            this.properties.putAll((Map<?, ?>)prop);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected static Properties prepareLoadedProperties(Properties properties) {
        OrderedProperties answer = new OrderedProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                value = AbstractLocationPropertiesSource.trimTrailingWhitespaces(s);
            }
            answer.put(key, value);
        }
        return answer;
    }

    private static String trimTrailingWhitespaces(String s) {
        int endIndex = s.length();
        int index = s.length() - 1;
        while (index >= 0 && s.charAt(index) == ' ') {
            endIndex = index--;
        }
        String answer = s.substring(0, endIndex);
        return answer;
    }
}

