/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.component.tika.TikaParseOutputFormat;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.tika.config.TikaConfig;

public class TikaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return TikaEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return TikaEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "tikaParseOutputFormat": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaParseOutputFormat((TikaParseOutputFormat)((Object)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaParseOutputFormat.class, (Object)value)));
                return true;
            }
            case "tikaParseOutputEncoding": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaParseOutputEncoding((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tikaConfig": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaConfig((TikaConfig)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaConfig.class, (Object)value));
                return true;
            }
            case "tikaConfigUri": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaConfigUri((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((TikaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((TikaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((TikaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)TikaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((TikaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)TikaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((TikaEndpoint)((Object)endpoint)).setSynchronous((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((TikaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "tikaparseoutputformat": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaParseOutputFormat((TikaParseOutputFormat)((Object)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaParseOutputFormat.class, (Object)value)));
                return true;
            }
            case "tikaparseoutputencoding": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaParseOutputEncoding((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tikaconfig": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaConfig((TikaConfig)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaConfig.class, (Object)value));
                return true;
            }
            case "tikaconfiguri": {
                ((TikaEndpoint)((Object)endpoint)).getTikaConfiguration().setTikaConfigUri((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((TikaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((TikaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((TikaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)TikaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((TikaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)TikaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((TikaEndpoint)((Object)endpoint)).setSynchronous((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((TikaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

