/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.processor.ThroughputLogger;
import org.apache.camel.util.URISupport;

public class DataSetConsumer
extends DefaultConsumer {
    private final CamelContext camelContext;
    private DataSetEndpoint endpoint;
    private Processor reporter;
    private ExecutorService executorService;

    public DataSetConsumer(DataSetEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.camelContext = endpoint.getCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        final DataSet dataSet = this.endpoint.getDataSet();
        final long preloadSize = this.endpoint.getPreloadSize();
        this.sendMessages(0L, preloadSize);
        this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, this.endpoint.getEndpointUri());
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (DataSetConsumer.this.endpoint.getInitialDelay() > 0L) {
                    try {
                        Thread.sleep(DataSetConsumer.this.endpoint.getInitialDelay());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                DataSetConsumer.this.sendMessages(preloadSize, dataSet.getSize());
            }
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
        }
    }

    protected void sendMessages(long startIndex, long endIndex) {
        try {
            for (long i = startIndex; i < endIndex; ++i) {
                Exchange exchange;
                block5: {
                    exchange = this.endpoint.createExchange(i);
                    this.getProcessor().process(exchange);
                    try {
                        long delay = this.endpoint.getProduceDelay();
                        if (delay <= 0L) break block5;
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (this.reporter == null) continue;
                this.reporter.process(exchange);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected ThroughputLogger createReporter() {
        String uri = URISupport.sanitizeUri((String)this.endpoint.getEndpointUri());
        CamelLogger logger = new CamelLogger(uri);
        ThroughputLogger answer = new ThroughputLogger(logger, Integer.valueOf((int)this.endpoint.getDataSet().getReportCount()));
        answer.setAction("Sent");
        return answer;
    }
}

