/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import java.util.Collection;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.cloud.CamelSpringCloudServiceRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;

@Configuration
@AutoConfigureAfter(value={ServiceRegistryAutoConfiguration.class})
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@ConditionalOnBean(value={org.springframework.cloud.client.serviceregistry.ServiceRegistry.class})
@Conditional(value={ServiceRegistryCondition.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
public class CamelSpringCloudServiceRegistryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServiceRegistry camelServiceRegistry(Collection<ConversionService> conversionServices, org.springframework.cloud.client.serviceregistry.ServiceRegistry serviceRegistry) {
        return new CamelSpringCloudServiceRegistry(conversionServices, serviceRegistry);
    }

    public static class ServiceRegistryCondition
    extends GroupCondition {
        public ServiceRegistryCondition() {
            super("camel.cloud", "camel.cloud.service-registry");
        }
    }
}

